/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.EnergyHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBEnergyInventory;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugePart;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileCentrifugeHeater
extends TileCentrifugePart
implements EnergyHandlerHost {
    public static final int POWER_USE = (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    protected final MBEnergyInventory energy = new MBEnergyInventory(this, 2000000).inputOnly();

    public TileCentrifugeHeater(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileCentrifugeHeater.class, TileCentrifugeHeater::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_HEATER), pos, state);
    }

    public boolean check(int para) {
        if (this.isActive() && para > 0 && this.energy.getEnergyStored() >= para * POWER_USE) {
            int power = this.energy.forceExtractEnergy(para * POWER_USE, false);
            return power >= para * POWER_USE;
        }
        return false;
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("energy", (Tag)this.energy.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.energy.deserializeNBT(provider, (Tag)data.getCompound("energy"));
    }

    public MBEnergyInventory getEnergyStorage() {
        return this.energy;
    }

    public Direction getFacing() {
        return MBSingletons.MODULAR_CENTRIFUGE_HEATER.getFacing(this.getBlockState());
    }
}

