/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugePart;
import com.glodblock.github.modularbees.util.MBTags;
import com.glodblock.github.modularbees.util.ServerTickTile;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileCentrifugeGearbox
extends TileCentrifugePart
implements ServerTickTile,
ItemHandlerHost {
    public static final int MAX_WAX = 1000;
    public static final int WAX_USAGE = (Integer)MBConfig.GEARBOX_WAX.get();
    public static final float BOOST = (float)MBConfig.GEARBOX_BOOST.getAsDouble();
    private final MBItemInventory inv = new MBItemInventory(this, 1).setFilter(this::isWax).inputOnly();
    private int wax = 0;

    public TileCentrifugeGearbox(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileCentrifugeGearbox.class, TileCentrifugeGearbox::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_GEARBOX), pos, state);
    }

    public float getBoostAndConsume() {
        if (this.wax >= WAX_USAGE) {
            this.wax -= WAX_USAGE;
            this.setChanged();
            return BOOST;
        }
        return 0.0f;
    }

    private boolean isWax(ItemStack stack) {
        return stack.is(ModTags.Common.WAXES) || stack.is(MBTags.WAX_BLOCK);
    }

    public int getWax() {
        return this.wax;
    }

    public void setWax(int wax) {
        this.wax = wax;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.inv.toList());
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("inv", (Tag)this.inv.serializeNBT(provider));
        data.putInt("wax", this.wax);
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.inv.deserializeNBT(provider, data.getCompound("inv"));
        this.wax = Math.min(data.getInt("wax"), 1000);
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.inv;
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.inv;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        if (this.isActive() && this.wax < 1000) {
            int use;
            ItemStack stack = this.inv.getStackInSlot(0);
            if (stack.is(ModTags.Common.WAXES)) {
                int use2 = Math.min(stack.getCount(), 1000 - this.wax);
                stack.shrink(use2);
                this.wax += use2;
            } else if (stack.is(MBTags.WAX_BLOCK) && (use = Math.min(stack.getCount(), (1000 - this.wax) / 9)) > 0) {
                stack.shrink(use);
                this.wax += use * 9;
            }
        }
    }
}

