/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.recipe;

import com.glodblock.github.modularbees.ModularBees;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import org.jetbrains.annotations.NotNull;

public record ElectrodeRecipe(ItemStack electrode, float power) implements Recipe<RecipeInput>
{
    public static final ResourceLocation ID = ModularBees.id("overclocker_electrode");
    public static final RecipeType<ElectrodeRecipe> TYPE = RecipeType.simple((ResourceLocation)ID);
    public static final RecipeSerializer<ElectrodeRecipe> SERIALIZER = new Serializer();
    private static IdentityHashMap<Item, ElectrodeRecipe> CACHE = null;

    public boolean matches(@NotNull RecipeInput input, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public String getGroup() {
        return "electrode";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map<Item, ElectrodeRecipe> getCache(@NotNull Level world) {
        if (CACHE == null) {
            CACHE = new IdentityHashMap();
            Collection recipes = world.getRecipeManager().byType(TYPE);
            for (RecipeHolder recipe : recipes) {
                CACHE.put(((ElectrodeRecipe)recipe.value()).electrode().getItem(), (ElectrodeRecipe)recipe.value());
            }
        }
        return CACHE;
    }

    @SubscribeEvent
    public static void onReload(OnDatapackSyncEvent event) {
        CACHE = null;
    }

    public static final class Builder {
        ItemStack electrode;
        float power = 1.0f;

        private Builder() {
        }

        public Builder input(ItemLike item) {
            this.electrode = new ItemStack(item);
            return this;
        }

        public Builder power(float power) {
            this.power = power;
            return this;
        }

        public void save(RecipeOutput consumer, ResourceLocation id) {
            if (this.electrode == null) {
                throw new NullPointerException("Input cannot be null! ID: %s".formatted(id));
            }
            if (this.power < 1.0f) {
                throw new IllegalArgumentException("Power must be greater than one! ID: %s".formatted(id));
            }
            ElectrodeRecipe recipe = new ElectrodeRecipe(this.electrode, this.power);
            consumer.accept(id, (Recipe)recipe, null);
        }
    }

    private static class Serializer
    implements RecipeSerializer<ElectrodeRecipe> {
        static final MapCodec<ElectrodeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("electrode").forGetter(r -> r.electrode), (App)Codec.FLOAT.fieldOf("power").forGetter(r -> Float.valueOf(r.power))).apply((Applicative)builder, ElectrodeRecipe::new));
        static final StreamCodec<RegistryFriendlyByteBuf, ElectrodeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, r -> r.electrode, (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.power), ElectrodeRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<ElectrodeRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ElectrodeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

