/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.compat.BridgingCrosshairTweaks;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.raytrace.PlacementAlignment;
import me.cg360.mod.bridging.util.GameSupport;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class CrosshairRenderingMixin {
    @Unique
    private static final int ICON_SIZE = 32;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private DebugScreenOverlay debugOverlay;

    @Inject(method={"renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="TAIL")})
    public void renderPlacementAssistMarker(GuiGraphics gui, DeltaTracker deltaTracker, CallbackInfo ci) {
        boolean isBridgingActive;
        if (BridgingStateTracker.getLastTickTarget() == null) {
            return;
        }
        if (BridgingCrosshairTweaks.forceHidden) {
            return;
        }
        if (this.minecraft.options.hideGui) {
            return;
        }
        if (!BridgingMod.getConfig().shouldShowCrosshair()) {
            return;
        }
        boolean bl = isBridgingActive = BridgingMod.getConfig().isBridgingEnabled() && (!BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || GameSupport.isControllerCrouching());
        if (!isBridgingActive) {
            return;
        }
        Direction direction = (Direction)BridgingStateTracker.getLastTickTarget().getB();
        PlacementAlignment alignment = PlacementAlignment.from(direction);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int w = gui.guiWidth();
        int h = gui.guiHeight();
        if (alignment == null) {
            return;
        }
        int x = (w - 32 + 1) / 2;
        int y = (h - 32 + 1) / 2;
        y += BridgingCrosshairTweaks.yShift;
        gui.blitSprite(alignment.getTexturePath(), x, y += this.debugOverlay.showDebugScreen() ? 15 : 0, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }
}

