/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.github.minecraftschurlimods.bibliocraft.BCConfig;
import com.github.minecraftschurlimods.bibliocraft.client.screen.BigBookScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.ClipboardScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.ClockScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.FancySignScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.RedstoneBookScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.StockroomCatalogScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.TypewriterPageScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.TypewriterScreen;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogListPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class ClientUtil {
    public static Minecraft getMc() {
        return Minecraft.getInstance();
    }

    public static ClientLevel getLevel() {
        return ClientUtil.getMc().level;
    }

    public static LocalPlayer getPlayer() {
        return ClientUtil.getMc().player;
    }

    public static Font getFont() {
        return ClientUtil.getMc().font;
    }

    public static void openBigBookScreen(ItemStack stack, Player player, InteractionHand hand) {
        ClientUtil.getMc().setScreen((Screen)new BigBookScreen(stack, player, hand));
    }

    public static void openBigBookScreen(ItemStack stack, Player player, BlockPos lectern) {
        ClientUtil.getMc().setScreen((Screen)new BigBookScreen(stack, player, lectern));
    }

    public static void openClipboardScreen(ItemStack stack, InteractionHand hand) {
        ClientUtil.getMc().setScreen((Screen)new ClipboardScreen(stack, hand));
    }

    public static void openClockScreen(BlockPos pos) {
        ClientUtil.getMc().setScreen((Screen)new ClockScreen(pos));
    }

    public static void openFancySignScreen(BlockPos pos, boolean back) {
        ClientUtil.getMc().setScreen((Screen)new FancySignScreen(pos, back));
    }

    public static void openRedstoneBookScreen() {
        ClientUtil.getMc().setScreen((Screen)new RedstoneBookScreen());
    }

    public static void openStockroomCatalogScreen(ItemStack stack, Player player, InteractionHand hand) {
        ClientUtil.getMc().setScreen((Screen)new StockroomCatalogScreen(stack, player, hand));
    }

    public static void openStockroomCatalogScreen(ItemStack stack, Player player, BlockPos lectern) {
        ClientUtil.getMc().setScreen((Screen)new StockroomCatalogScreen(stack, player, lectern));
    }

    public static void openTypewriterScreen(BlockPos pos) {
        ClientUtil.getMc().setScreen((Screen)new TypewriterScreen(pos));
    }

    public static void openTypewriterPageScreen(ItemStack stack) {
        ClientUtil.getMc().setScreen((Screen)new TypewriterPageScreen(stack));
    }

    public static void setupCenteredBER(PoseStack stack, BlockEntity blockEntity) {
        stack.translate(0.5, 0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            stack.mulPose(Axis.YP.rotationDegrees(switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case Direction.SOUTH -> 0.0f;
                case Direction.EAST -> 90.0f;
                default -> 180.0f;
                case Direction.WEST -> 270.0f;
            }));
        }
    }

    public static void renderFixedItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        ClientUtil.renderItem(item, stack, buffer, light, overlay, ItemDisplayContext.FIXED);
    }

    public static void renderGuiItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        ClientUtil.renderItem(item, stack, buffer, light, overlay, ItemDisplayContext.GUI);
    }

    public static void renderItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay, ItemDisplayContext context) {
        Minecraft minecraft = ClientUtil.getMc();
        ItemRenderer renderer = minecraft.getItemRenderer();
        renderer.render(item, context, context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND, stack, buffer, light, overlay, renderer.getModel(item, (Level)minecraft.level, null, 0));
    }

    public static void renderBakedModel(BakedModel model, PoseStack stack, MultiBufferSource buffer, Level level, BlockPos pos, BlockState state, RandomSource random, ModelData modelData) {
        ModelBlockRenderer renderer = ClientUtil.getMc().getBlockRenderer().getModelRenderer();
        int color = ClientUtil.getMc().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
        for (RenderType type : model.getRenderTypes(state, random, modelData)) {
            renderer.renderModel(stack.last(), buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)type, (boolean)false)), state, model, red, green, blue, light, OverlayTexture.NO_OVERLAY, modelData, type);
        }
    }

    public static void renderXpText(String text, GuiGraphics graphics, int centerX, int startY) {
        Font font = ClientUtil.getFont();
        int startX = centerX - font.width(text) / 2;
        graphics.drawString(font, text, startX + 1, startY, 0, false);
        graphics.drawString(font, text, startX - 1, startY, 0, false);
        graphics.drawString(font, text, startX, startY + 1, 0, false);
        graphics.drawString(font, text, startX, startY - 1, 0, false);
        graphics.drawString(font, text, startX, startY, 8453920, false);
    }

    public static boolean isPride() {
        return (Boolean)BCConfig.ENABLE_PRIDE.get() != false && ((Boolean)BCConfig.ENABLE_PRIDE_ALWAYS.get() != false || Calendar.getInstance().get(2) == 5);
    }

    public static void setStockroomCatalogList(StockroomCatalogListPacket packet) {
        Screen screen = ClientUtil.getMc().screen;
        if (screen instanceof StockroomCatalogScreen) {
            StockroomCatalogScreen screen2 = (StockroomCatalogScreen)screen;
            screen2.setFromPacket(packet);
        }
    }
}

