/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.typewriter;

import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCFacingEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TypewriterBlock
extends BCFacingEntityBlock {
    private static final VoxelShape NORTH_SHAPE = ShapeUtil.combine(Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.125, (double)0.125, (double)0.21875, (double)0.875, (double)0.15625, (double)0.875), Shapes.box((double)0.125, (double)0.15625, (double)0.3125, (double)0.875, (double)0.1875, (double)0.875), Shapes.box((double)0.125, (double)0.1875, (double)0.40625, (double)0.875, (double)0.21875, (double)0.875), Shapes.box((double)0.125, (double)0.21875, (double)0.5, (double)0.25, (double)0.375, (double)0.6875), Shapes.box((double)0.75, (double)0.21875, (double)0.5, (double)0.875, (double)0.375, (double)0.6875), Shapes.box((double)0.125, (double)0.21875, (double)0.6875, (double)0.875, (double)0.375, (double)0.875), Shapes.box((double)0.125, (double)0.375, (double)0.6875, (double)0.25, (double)0.5625, (double)0.875), Shapes.box((double)0.75, (double)0.375, (double)0.6875, (double)0.875, (double)0.5625, (double)0.875), Shapes.box((double)0.25, (double)0.375, (double)0.84375, (double)0.75, (double)0.5625, (double)0.875), Shapes.box((double)0.0625, (double)0.40625, (double)0.71875, (double)0.9375, (double)0.53125, (double)0.84375));
    private static final VoxelShape EAST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape NORTH_COLLISION_SHAPE = ShapeUtil.combine(Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.15625, (double)0.875), Shapes.box((double)0.125, (double)0.15625, (double)0.3125, (double)0.875, (double)0.21875, (double)0.875), Shapes.box((double)0.125, (double)0.21875, (double)0.5, (double)0.875, (double)0.375, (double)0.875), Shapes.box((double)0.0625, (double)0.375, (double)0.6875, (double)0.9375, (double)0.5625, (double)0.875));
    private static final VoxelShape EAST_COLLISION_SHAPE = ShapeUtil.rotate(NORTH_COLLISION_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_COLLISION_SHAPE = ShapeUtil.rotate(NORTH_COLLISION_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_COLLISION_SHAPE = ShapeUtil.rotate(NORTH_COLLISION_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    public static final IntegerProperty PAPER = IntegerProperty.create((String)"paper", (int)0, (int)7);

    public TypewriterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PAPER, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH_COLLISION_SHAPE;
            case Direction.EAST -> EAST_COLLISION_SHAPE;
            case Direction.SOUTH -> SOUTH_COLLISION_SHAPE;
            case Direction.WEST -> WEST_COLLISION_SHAPE;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PAPER});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TypewriterBlockEntity) {
            TypewriterBlockEntity typewriter = (TypewriterBlockEntity)blockEntity;
            ItemStack item = typewriter.getItem(1);
            if (!item.isEmpty()) {
                player.addItem(typewriter.takeOutput());
                return InteractionResult.SUCCESS;
            }
            if (typewriter.getItem(0).isEmpty()) {
                player.displayClientMessage(Translations.TYPEWRITER_NO_PAPER, true);
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide()) {
                ClientUtil.openTypewriterScreen(pos);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TypewriterBlockEntity) {
            TypewriterBlockEntity typewriter = (TypewriterBlockEntity)blockEntity;
            if (stack.is(BCTags.Items.TYPEWRITER_PAPER)) {
                return typewriter.insertPaper(stack) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TypewriterBlockEntity(pos, state);
    }
}

