/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancysign;

import com.github.minecraftschurlimods.bibliocraft.content.fancysign.FancySignContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FancySignBlockEntity
extends BlockEntity {
    private static final String FRONT_CONTENT_KEY = "front_content";
    private static final String BACK_CONTENT_KEY = "back_content";
    private FancySignContent frontContent = FancySignContent.withSize(16);
    private FancySignContent backContent = FancySignContent.withSize(16);

    public FancySignBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.FANCY_SIGN.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(FRONT_CONTENT_KEY)) {
            this.setFrontContent(CodecUtil.decodeNbt(FancySignContent.CODEC, tag.get(FRONT_CONTENT_KEY)));
        }
        if (tag.contains(BACK_CONTENT_KEY)) {
            this.setBackContent(CodecUtil.decodeNbt(FancySignContent.CODEC, tag.get(BACK_CONTENT_KEY)));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(FRONT_CONTENT_KEY, CodecUtil.encodeNbt(FancySignContent.CODEC, this.getFrontContent()));
        tag.put(BACK_CONTENT_KEY, CodecUtil.encodeNbt(FancySignContent.CODEC, this.getBackContent()));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (!this.getFrontContent().lines().isEmpty()) {
            tag.put(FRONT_CONTENT_KEY, CodecUtil.encodeNbt(FancySignContent.CODEC, this.getFrontContent()));
        }
        if (!this.getBackContent().lines().isEmpty()) {
            tag.put(BACK_CONTENT_KEY, CodecUtil.encodeNbt(FancySignContent.CODEC, this.getBackContent()));
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        if (tag.contains(FRONT_CONTENT_KEY)) {
            this.setFrontContent(CodecUtil.decodeNbt(FancySignContent.CODEC, tag.get(FRONT_CONTENT_KEY)));
        }
        if (tag.contains(BACK_CONTENT_KEY)) {
            this.setBackContent(CodecUtil.decodeNbt(FancySignContent.CODEC, tag.get(BACK_CONTENT_KEY)));
        }
    }

    public FancySignContent getFrontContent() {
        return this.frontContent;
    }

    public void setFrontContent(FancySignContent frontContent) {
        this.frontContent = frontContent;
        this.setChanged();
    }

    public FancySignContent getBackContent() {
        return this.backContent;
    }

    public void setBackContent(FancySignContent backContent) {
        this.backContent = backContent;
        this.setChanged();
    }
}

