/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.util.Lazy;

public class WildcardedRLMatcher
implements Predicate<ResourceLocation> {
    private final Set<String> namespaces = new ObjectOpenHashSet();
    private final Set<ResourceLocation> reslocs = new ObjectOpenHashSet();

    public static Lazy<WildcardedRLMatcher> lazyFromConfig(ModConfigSpec.ConfigValue<List<? extends String>> configValue) {
        return Lazy.of(() -> new WildcardedRLMatcher((Collection)configValue.get()));
    }

    public WildcardedRLMatcher(Collection<? extends String> toMatch) {
        for (String string : toMatch) {
            String[] parts = string.split(":", 2);
            if (parts.length == 1 || parts[1].isEmpty() || parts[1].equals("*")) {
                this.namespaces.add(parts[0]);
                continue;
            }
            try {
                this.reslocs.add(ResourceLocation.parse((String)string));
            }
            catch (ResourceLocationException e) {
                Log.error("WildcardedRLMatcher: invalid resource location '{}'", string);
            }
        }
    }

    public boolean isEmpty() {
        return this.reslocs.isEmpty() && this.namespaces.isEmpty();
    }

    @Override
    public boolean test(ResourceLocation resourceLocation) {
        return this.reslocs.contains(resourceLocation) || this.namespaces.contains(resourceLocation.getNamespace());
    }

    public static boolean isValidRL(Object input) {
        if (!(input instanceof String)) {
            return false;
        }
        String str = (String)input;
        if (ResourceLocation.tryParse((String)str) != null) {
            return true;
        }
        String[] parts = str.split(":");
        return parts.length == 2 && ResourceLocation.isValidNamespace((String)parts[0]) && (parts[0].isEmpty() || parts[1].equals("*"));
    }
}

