/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceUtils {
    public static HitResult getEntityLookedObject(LivingEntity entity, double maxDistance) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec(entity, maxDistance);
        ClipContext ctx = new ClipContext((Vec3)vecs.getLeft(), (Vec3)vecs.getRight(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(ctx);
    }

    public static Pair<Vec3, Vec3> getStartAndEndLookVec(LivingEntity entity, double maxDistance) {
        Vec3 entityVec = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 maxDistVec = entityVec.add(entity.getViewVector(1.0f).scale(maxDistance));
        return new ImmutablePair((Object)entity.getEyePosition(1.0f), (Object)maxDistVec);
    }

    public static HitResult getMouseOverServer(LivingEntity lookingEntity, double range) {
        HitResult result = RayTraceUtils.raytraceEntityBlocks(lookingEntity, range);
        double rangeSq = range * range;
        Pair<Vec3, Vec3> startAndEnd = RayTraceUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3 eyePos = (Vec3)startAndEnd.getLeft();
        if (result.getType() != HitResult.Type.MISS) {
            rangeSq = result.getLocation().distanceToSqr(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vec3 hitVec = null;
        Entity focusedEntity = null;
        Vec3 lookVec = lookingEntity.getLookAngle().scale(range + 1.0);
        AABB box = lookingEntity.getBoundingBox().inflate(lookVec.x, lookVec.y, lookVec.z);
        for (Entity entity : lookingEntity.level().getEntities((Entity)lookingEntity, box, Entity::isPickable)) {
            double rangeSq3;
            AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            Optional vec = aabb.clip(eyePos, (Vec3)startAndEnd.getRight());
            if (aabb.contains(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = vec.orElse(eyePos);
                rangeSq2 = 0.0;
                continue;
            }
            if (!vec.isPresent() || !((rangeSq3 = eyePos.distanceToSqr((Vec3)vec.get())) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.getVehicle() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = (Vec3)vec.get();
                continue;
            }
            focusedEntity = entity;
            hitVec = (Vec3)vec.get();
            rangeSq2 = rangeSq3;
        }
        return focusedEntity != null && rangeSq2 < rangeSq ? new EntityHitResult(focusedEntity, hitVec) : result;
    }

    private static HitResult raytraceEntityBlocks(LivingEntity entity, double range) {
        Pair<Vec3, Vec3> startAndEnd = RayTraceUtils.getStartAndEndLookVec(entity, (float)range);
        ClipContext ctx = new ClipContext((Vec3)startAndEnd.getLeft(), (Vec3)startAndEnd.getRight(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(ctx);
    }
}

