/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class RegulatorModule
extends AbstractRedstoneReceivingModule
implements IInfluenceDispersing {
    private BlockCapabilityCache<IAirHandlerMachine, Direction> airHandlerCache;

    public RegulatorModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.REGULATOR_TUBE_MODULE.get();
    }

    @Override
    public int getMaxDispersion() {
        return this.getCachedNeighbourAirHandler().map(h -> {
            int maxDispersion = (int)((this.getThreshold() - h.getPressure()) * (float)h.getVolume());
            return Math.max(0, maxDispersion);
        }).orElse(0);
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public float getThreshold() {
        return this.upgraded ? super.getThreshold() : 4.9f * (float)(15 - this.getReceivingRedstoneLevel()) / 15.0f;
    }

    private Optional<IAirHandlerMachine> getCachedNeighbourAirHandler() {
        if (this.airHandlerCache == null) {
            BlockCapabilityCache blockCapabilityCache;
            Level level = this.pressureTube.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                blockCapabilityCache = BlockCapabilityCache.create(PNCCapabilities.AIR_HANDLER_MACHINE, (ServerLevel)level2, (BlockPos)this.pressureTube.getBlockPos().relative(this.dir), (Object)this.dir.getOpposite(), () -> !this.pressureTube.isRemoved(), () -> {});
            } else {
                blockCapabilityCache = null;
            }
            this.airHandlerCache = blockCapabilityCache;
        }
        return this.airHandlerCache == null ? Optional.empty() : Optional.ofNullable((IAirHandlerMachine)this.airHandlerCache.getCapability());
    }

    @Override
    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return hitInfo.dir() == this.getDirection() || hitInfo == PressureTubeBlock.TubeHitInfo.CENTER;
    }
}

