/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ComputerCraft;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class PneumaticTilePeripheral
implements IDynamicPeripheral,
ComputerEventManager.IComputerEventSender {
    private final ILuaMethodProvider provider;
    private final CopyOnWriteArrayList<IComputerAccess> attachedComputers = new CopyOnWriteArrayList();

    private PneumaticTilePeripheral(ILuaMethodProvider provider) {
        this.provider = provider;
    }

    private static PneumaticTilePeripheral maybe(Object o, Direction dir) {
        PneumaticTilePeripheral pneumaticTilePeripheral;
        if (o instanceof ILuaMethodProvider) {
            ILuaMethodProvider p = (ILuaMethodProvider)o;
            pneumaticTilePeripheral = new PneumaticTilePeripheral(p);
        } else {
            pneumaticTilePeripheral = null;
        }
        return pneumaticTilePeripheral;
    }

    static void attachPeripheralCap(RegisterCapabilitiesEvent event) {
        if (ComputerCraft.available) {
            ModBlockEntityTypes.streamBlockEntities().forEach(blockEntity -> {
                if (blockEntity instanceof ILuaMethodProvider) {
                    event.registerBlockEntity(PeripheralCapability.get(), blockEntity.getType(), PneumaticTilePeripheral::maybe);
                }
            });
        }
    }

    static Optional<IPeripheral> getPeripheral(BlockEntity blockEntity) {
        return Optional.ofNullable((IPeripheral)blockEntity.getLevel().getCapability(PeripheralCapability.get(), blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)Direction.UP));
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.provider.getLuaMethodRegistry().getMethodNames();
    }

    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext ctx, int method, @Nonnull IArguments args) throws LuaException {
        try {
            return MethodResult.of((Object[])this.provider.getLuaMethodRegistry().getMethod(method).call(args.getAll()));
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Nonnull
    public String getType() {
        return this.provider.getPeripheralType();
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other != null && this.getTarget() == other.getTarget();
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Override
    public void sendEvent(BlockEntity te, String name, Object ... params) {
        this.attachedComputers.forEach(a -> a.queueEvent(name, params));
    }

    public Object getTarget() {
        return this.provider;
    }
}

