/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public class AssemblyRecipeImpl
extends AssemblyRecipe {
    private final SizedIngredient input;
    private final ItemStack output;
    private final AssemblyRecipe.AssemblyProgramType program;

    public AssemblyRecipeImpl(@Nonnull SizedIngredient input, @Nonnull ItemStack output, AssemblyRecipe.AssemblyProgramType program) {
        this.input = input;
        this.output = output;
        this.program = program;
    }

    @Override
    public SizedIngredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.program;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.getCount() >= this.getInputAmount();
    }

    public RecipeSerializer<?> getSerializer() {
        return switch (this.getProgramType()) {
            case AssemblyRecipe.AssemblyProgramType.LASER -> ModRecipeSerializers.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL -> ModRecipeSerializers.ASSEMBLY_DRILL.get();
            default -> throw new IllegalStateException("invalid program type: " + String.valueOf((Object)this.getProgramType()));
        };
    }

    public RecipeType<?> getType() {
        return switch (this.getProgramType()) {
            default -> throw new MatchException(null, null);
            case AssemblyRecipe.AssemblyProgramType.DRILL -> ModRecipeTypes.ASSEMBLY_DRILL.get();
            case AssemblyRecipe.AssemblyProgramType.LASER -> ModRecipeTypes.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL_LASER -> ModRecipeTypes.ASSEMBLY_DRILL_LASER.get();
        };
    }

    public static Map<ResourceLocation, RecipeHolder<AssemblyRecipe>> calculateAssemblyChain(List<RecipeHolder<AssemblyRecipe>> drillRecipes, List<RecipeHolder<AssemblyRecipe>> laserRecipes) {
        HashMap<ResourceLocation, RecipeHolder<AssemblyRecipe>> drillLaser = new HashMap<ResourceLocation, RecipeHolder<AssemblyRecipe>>();
        for (RecipeHolder<AssemblyRecipe> h1 : drillRecipes) {
            for (RecipeHolder<AssemblyRecipe> h2 : laserRecipes) {
                AssemblyRecipe r1 = (AssemblyRecipe)h1.value();
                AssemblyRecipe r2 = (AssemblyRecipe)h2.value();
                if (!r2.getInput().test(r1.getOutput()) || r1.getOutput().getCount() % r2.getInputAmount() != 0 || r2.getOutput().getMaxStackSize() < r2.getOutput().getCount() * (r1.getOutput().getCount() / r2.getInputAmount())) continue;
                ItemStack output = r2.getOutput().copy();
                output.setCount(output.getCount() * (r1.getOutput().getCount() / r2.getInputAmount()));
                ResourceLocation id = PneumaticRegistry.RL(h1.id().getPath() + "_" + h2.id().getPath());
                drillLaser.put(id, (RecipeHolder<AssemblyRecipe>)new RecipeHolder(id, (Recipe)new AssemblyRecipeImpl(r1.getInput(), output, AssemblyRecipe.AssemblyProgramType.DRILL_LASER)));
            }
        }
        return drillLaser;
    }

    public static class Serializer<T extends AssemblyRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(AssemblyRecipe::getInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(AssemblyRecipe::getOutput), (App)AssemblyRecipe.AssemblyProgramType.CODEC.validate(Serializer::checkNotDrillAndLaser).fieldOf("program").forGetter(AssemblyRecipe::getProgramType)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC, AssemblyRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, AssemblyRecipe::getOutput, (StreamCodec)NeoForgeStreamCodecs.enumCodec(AssemblyRecipe.AssemblyProgramType.class), AssemblyRecipe::getProgramType, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        @NotNull
        private static DataResult<AssemblyRecipe.AssemblyProgramType> checkNotDrillAndLaser(AssemblyRecipe.AssemblyProgramType type) {
            return type == AssemblyRecipe.AssemblyProgramType.DRILL_LASER ? DataResult.error(() -> "'drill_laser' may not be used as a recipe type!") : DataResult.success((Object)((Object)type));
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends AssemblyRecipe> {
        public T create(@Nonnull SizedIngredient var1, @Nonnull ItemStack var2, AssemblyRecipe.AssemblyProgramType var3);
    }
}

