/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import java.util.Optional;
import java.util.UUID;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronUtil;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.OfferType;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.playerfilter.PlayerFilter;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class AmadronPlayerOffer
extends AmadronOffer {
    public static final StreamCodec<RegistryFriendlyByteBuf, AmadronPlayerOffer> STREAM_CODEC = StreamCodec.of((buf, playerOffer) -> playerOffer.write((RegistryFriendlyByteBuf)buf), AmadronPlayerOffer::playerOfferFromBuf);
    private final String offeringPlayerName;
    private UUID offeringPlayerId;
    private GlobalPos providingPos;
    private GlobalPos returningPos;
    private int pendingPayments;
    private BlockEntity cachedInput;
    private BlockEntity cachedOutput;

    private AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, String playerName, UUID playerId, PlayerFilter whitelist, PlayerFilter blacklist) {
        super(id, input, output, true, false, 0, -1, -1, whitelist, blacklist);
        this.offeringPlayerName = playerName;
        this.offeringPlayerId = playerId;
        this.inStock = 0;
    }

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, Player offeringPlayer, PlayerFilter whitelist, PlayerFilter blacklist) {
        this(id, input, output, offeringPlayer.getGameProfile().getName(), offeringPlayer.getGameProfile().getId(), whitelist, blacklist);
    }

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, Player player) {
        this(id, input, output, player, PlayerFilter.YES, PlayerFilter.NO);
    }

    public AmadronPlayerOffer setProvidingPosition(GlobalPos pos) {
        this.providingPos = pos;
        this.cachedInput = null;
        return this;
    }

    public AmadronPlayerOffer setReturningPosition(GlobalPos pos) {
        this.returningPos = pos;
        this.cachedOutput = null;
        return this;
    }

    @Override
    public OfferType getOfferType() {
        return OfferType.PLAYER;
    }

    public AmadronPlayerOffer getReversedOffer() {
        ResourceLocation reversedId = AmadronPlayerOffer.getReversedId(this.getOfferId());
        AmadronPlayerOffer reversed = new AmadronPlayerOffer(reversedId, this.getOutput(), this.getInput(), this.offeringPlayerName, this.offeringPlayerId, this.whitelist, this.blacklist);
        reversed.providingPos = this.providingPos;
        reversed.returningPos = this.returningPos;
        reversed.inStock = this.inStock;
        reversed.pendingPayments = this.pendingPayments;
        return reversed;
    }

    public void updatePlayerId() {
        ServerPlayer player = PneumaticCraftUtils.getPlayerFromName(this.offeringPlayerName);
        if (player != null) {
            this.offeringPlayerId = player.getGameProfile().getId();
        }
    }

    public void addPayment(int payment) {
        this.pendingPayments += payment;
    }

    @Override
    public Component getVendorName() {
        return Component.literal((String)this.offeringPlayerName);
    }

    public UUID getPlayerId() {
        return this.offeringPlayerId;
    }

    @Override
    public void onTrade(int tradingAmount, String buyingPlayer) {
        ServerPlayer player = PneumaticCraftUtils.getPlayerFromId(this.offeringPlayerId);
        if (player != null && ((Boolean)ConfigHelper.common().amadron.notifyOfDealMade.get()).booleanValue()) {
            NetworkHandler.sendToPlayer(new PacketAmadronTradeNotifyDeal(this, tradingAmount, buyingPlayer), player);
        }
    }

    @Override
    public boolean isRemovableBy(Player player) {
        return this.getPlayerId().equals(player.getUUID());
    }

    public void notifyRestock() {
        ServerPlayer player = PneumaticCraftUtils.getPlayerFromId(this.getPlayerId());
        if (player != null) {
            player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.amadronRestocked", this.getDescription(), this.getStock()), false);
        }
    }

    public boolean payout() {
        BlockEntity returning = this.getReturningTileEntity();
        if (this.pendingPayments > 0) {
            int pay0 = Math.min(this.pendingPayments, 50);
            int paying = this.getInput().apply(itemStack -> IOHelper.getInventoryForBlock(returning).map(h -> this.getInput().findSpaceInItemOutput((IItemHandler)h, pay0)).orElse(0), fluidStack -> IOHelper.getFluidHandlerForBlock(returning).map(h -> this.getInput().findSpaceInFluidOutput((IFluidHandler)h, pay0)).orElse(0));
            if (paying > 0) {
                this.pendingPayments -= paying;
                this.getInput().accept(itemStack -> DroneRegistry.getInstance().deliverItemsAmazonStyle(this.returningPos, AmadronUtil.buildStacks(itemStack, paying)), fluidStack -> DroneRegistry.getInstance().deliverFluidAmazonStyle(this.returningPos, AmadronUtil.buildFluidStack(fluidStack, paying)));
                return true;
            }
        }
        return false;
    }

    public void returnStock() {
        while (this.inStock > 0) {
            int stock = Math.min(this.inStock, 64);
            this.inStock -= stock;
            this.getOutput().accept(itemStack -> DroneRegistry.getInstance().deliverItemsAmazonStyle(this.providingPos, AmadronUtil.buildStacks(itemStack, stock)), fluidStack -> DroneRegistry.getInstance().deliverFluidAmazonStyle(this.providingPos, AmadronUtil.buildFluidStack(fluidStack, stock)));
        }
    }

    public BlockEntity getProvidingTileEntity() {
        if ((this.cachedInput == null || this.cachedInput.isRemoved()) && this.providingPos != null) {
            this.cachedInput = GlobalPosHelper.getTileEntity(this.providingPos);
        }
        return this.cachedInput;
    }

    BlockEntity getReturningTileEntity() {
        if ((this.cachedOutput == null || this.cachedOutput.isRemoved()) && this.returningPos != null) {
            this.cachedOutput = GlobalPosHelper.getTileEntity(this.returningPos);
        }
        return this.cachedOutput;
    }

    public GlobalPos getProvidingPos() {
        return this.providingPos;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        super.write(buf);
        buf.writeUtf(this.offeringPlayerName);
        buf.writeUUID(this.offeringPlayerId);
        buf.writeOptional(Optional.ofNullable(this.providingPos), (StreamEncoder)GlobalPos.STREAM_CODEC);
        buf.writeOptional(Optional.ofNullable(this.returningPos), (StreamEncoder)GlobalPos.STREAM_CODEC);
        buf.writeVarInt(this.inStock);
        buf.writeVarInt(this.pendingPayments);
    }

    public static AmadronPlayerOffer playerOfferFromBuf(RegistryFriendlyByteBuf buf) {
        AmadronRecipe recipe = (AmadronRecipe)ModRecipeSerializers.AMADRON_OFFERS.get().streamCodec().decode((Object)buf);
        if (recipe instanceof AmadronOffer) {
            AmadronOffer offer = (AmadronOffer)recipe;
            AmadronPlayerOffer playerOffer = new AmadronPlayerOffer(offer.getOfferId(), offer.getInput(), offer.getOutput(), buf.readUtf(100), buf.readUUID(), offer.whitelist, offer.blacklist);
            playerOffer.setProvidingPosition(buf.readOptional((StreamDecoder)GlobalPos.STREAM_CODEC).orElse(null));
            playerOffer.setReturningPosition(buf.readOptional((StreamDecoder)GlobalPos.STREAM_CODEC).orElse(null));
            playerOffer.inStock = buf.readVarInt();
            playerOffer.pendingPayments = buf.readVarInt();
            return playerOffer;
        }
        throw new IllegalStateException("recipe isn't an amadron offer?! impossible!");
    }

    public JsonObject toJson() {
        JsonObject json = ((JsonElement)ModRecipeSerializers.AMADRON_OFFERS.get().codec().encode((Object)this, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).build((Object)new JsonObject()).resultOrPartial(s -> Log.error("can't create json: " + s, new Object[0])).orElseThrow()).getAsJsonObject();
        json.addProperty("offeringPlayerName", this.offeringPlayerName);
        json.addProperty("offeringPlayerId", this.offeringPlayerId.toString());
        json.addProperty("inStock", (Number)this.inStock);
        json.addProperty("pendingPayments", (Number)this.pendingPayments);
        if (this.providingPos != null) {
            json.add("providingPos", GlobalPosHelper.toJson(this.providingPos));
        }
        if (this.returningPos != null) {
            json.add("returningPos", GlobalPosHelper.toJson(this.returningPos));
        }
        return json;
    }

    public static AmadronPlayerOffer fromJson(JsonObject json) {
        AmadronOffer baseOffer = (AmadronOffer)ModRecipeSerializers.AMADRON_OFFERS.get().codec().decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap((JsonElement)json).getOrThrow()).resultOrPartial(err -> {
            throw new JsonSyntaxException(err);
        }).orElseThrow(() -> new JsonSyntaxException("invalid json syntax"));
        AmadronPlayerOffer playerOffer = new AmadronPlayerOffer(baseOffer.getOfferId(), baseOffer.getInput(), baseOffer.getOutput(), json.get("offeringPlayerName").getAsString(), UUID.fromString(json.get("offeringPlayerId").getAsString()), baseOffer.whitelist, baseOffer.blacklist);
        playerOffer.inStock = json.get("inStock").getAsInt();
        playerOffer.pendingPayments = json.get("pendingPayments").getAsInt();
        if (json.has("providingPos")) {
            playerOffer.providingPos = GlobalPosHelper.fromJson(json.get("providingPos").getAsJsonObject());
        }
        if (json.has("returningPos")) {
            playerOffer.returningPos = GlobalPosHelper.fromJson(json.get("returningPos").getAsJsonObject());
        }
        return playerOffer;
    }

    @Override
    public boolean equivalentTo(AmadronPlayerOffer otherOffer) {
        return super.equivalentTo(otherOffer) && this.offeringPlayerId.equals(otherOffer.offeringPlayerId);
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.offeringPlayerName;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AmadronPlayerOffer) {
            AmadronPlayerOffer offer = (AmadronPlayerOffer)o;
            return super.equals(o) && offer.offeringPlayerId.equals(this.offeringPlayerId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.offeringPlayerId.hashCode();
    }

    public static ResourceLocation getReversedId(ResourceLocation id) {
        String s = id.toString();
        return s.endsWith("_rev") ? ResourceLocation.parse((String)s.replaceFirst("_rev$", "")) : ResourceLocation.parse((String)(s + "_rev"));
    }
}

