/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.Optional;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.config.CommonConfig;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ScubaHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    public static final Vector3f BUBBLE_SPEED = new Vector3f(0.0f, 0.2f, 0.0f);
    public static final Vector3f BUBBLE_AREA = new Vector3f(1.0f, 1.0f, 1.0f);

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.SCUBA;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.SCUBA.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        if (!player.level().isClientSide && enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.HEAD) && player.getAirSupply() < player.getMaxAirSupply() / 2) {
            int thresholdDepth;
            CommonConfig.Armor armorConf = ConfigHelper.common().armor;
            int airMult = (Integer)armorConf.scubaMultiplier.get();
            if ((Double)armorConf.scubaAirUsagePerBlockDepth.get() > 0.0 && player.position().y < (double)(thresholdDepth = player.level().getSeaLevel() - (Integer)armorConf.scubaMinAirUsageIncreaseDepth.get())) {
                airMult += (int)Math.round((Double)armorConf.scubaAirUsagePerBlockDepth.get() * ((double)thresholdDepth - player.position().y));
            }
            float airInHelmet = commonArmorHandler.getAir(EquipmentSlot.HEAD);
            int playerAirAdded = (int)Math.min((float)(player.getMaxAirSupply() - player.getAirSupply()), airInHelmet / (float)airMult);
            player.setAirSupply(player.getAirSupply() + playerAirAdded);
            commonArmorHandler.addAir(EquipmentSlot.HEAD, -(playerAirAdded * airMult));
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundSource.PLAYERS, player.blockPosition(), 1.0f, 1.0f, false), (ServerPlayer)player);
            Vec3 eyes = player.getEyePosition(1.0f).add(player.getLookAngle().scale(0.5));
            NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.BUBBLE, eyes.toVector3f().add(-0.5f, 0.0f, -0.5f), BUBBLE_SPEED, 10, Optional.of(BUBBLE_AREA)), player.level(), player.blockPosition());
        }
    }
}

