/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IActiveEntityHacks;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.BlockTrackLootable;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.Validate;

public enum CommonArmorRegistry implements ICommonArmorRegistry
{
    INSTANCE;

    public final Map<Class<? extends Entity>, Supplier<? extends IHackableEntity<?>>> hackableEntities = new ConcurrentHashMap();
    public final Map<ResourceLocation, Supplier<? extends IHackableEntity<?>>> idToEntityHackables = new ConcurrentHashMap();
    private final Multimap<EntityType<?>, IHackableEntity<?>> hackablesByType = ArrayListMultimap.create();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableBlocks = new ConcurrentHashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableTaggedBlocks = new ConcurrentHashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<TagKey<Block>, Supplier<? extends IHackableBlock>> pendingBlockTags = new ConcurrentHashMap<TagKey<Block>, Supplier<? extends IHackableBlock>>();
    private final Map<ResourceLocation, Supplier<? extends IHackableBlock>> idToBlockHackables = new ConcurrentHashMap<ResourceLocation, Supplier<? extends IHackableBlock>>();

    public static CommonArmorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public synchronized <T extends IArmorUpgradeHandler<?>> T registerUpgradeHandler(T handler) {
        Validate.notNull(handler, (String)"Upgrade handler can't be null!", (Object[])new Object[0]);
        return ArmorUpgradeRegistry.getInstance().registerUpgradeHandler(handler);
    }

    @Override
    public ICommonArmorHandler getCommonArmorHandler(Player player) {
        return CommonArmorHandler.getHandlerForPlayer(player);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Supplier<? extends IHackableEntity<?>> iHackable) {
        Validate.isTrue((!(iHackable instanceof Entity) ? 1 : 0) != 0, (String)"Entities that already implement IHackableEntity do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableEntity<?> hackableEntity = iHackable.get();
        hackableEntity.getHackableId();
        this.idToEntityHackables.put(hackableEntity.getHackableId(), iHackable);
        this.hackableEntities.put(entityClazz, iHackable);
    }

    @Override
    public void addHackable(Block block, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableBlock hackableBlock = iHackable.get();
        hackableBlock.getHackableId();
        this.idToBlockHackables.put(hackableBlock.getHackableId(), iHackable);
        this.hackableBlocks.put(block, iHackable);
    }

    @Override
    public void addHackable(TagKey<Block> blockTag, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        this.pendingBlockTags.put(blockTag, iHackable);
    }

    @Override
    public Collection<IHackableEntity<?>> getCurrentEntityHacks(Entity entity) {
        return HackManager.getActiveHacks(entity).map(IActiveEntityHacks::getCurrentHacks).orElse(List.of());
    }

    @Override
    public void registerBlockTrackerLootable(BiConsumer<Player, BlockEntity> consumer) {
        BlockTrackLootable.INSTANCE.addLootable(consumer);
    }

    @Override
    public Optional<IArmorUpgradeHandler<?>> getArmorUpgradeHandler(ResourceLocation id) {
        return Optional.ofNullable(ArmorUpgradeRegistry.getInstance().getUpgradeEntry(id));
    }

    public void resolveBlockTags() {
        this.hackableTaggedBlocks.clear();
        this.pendingBlockTags.forEach((tagKey, hackable) -> BuiltInRegistries.BLOCK.getTagOrEmpty(tagKey).forEach(arg_0 -> this.lambda$resolveBlockTags$0((Supplier)hackable, arg_0)));
    }

    public IHackableBlock getHackable(Block block) {
        Supplier<? extends IHackableBlock> sup = this.hackableBlocks.get(block);
        if (sup != null) {
            return sup.get();
        }
        sup = this.hackableTaggedBlocks.get(block);
        return sup == null ? null : sup.get();
    }

    public IHackableEntity<?> getHackable(Entity entity, Player player) {
        if (!this.hackablesByType.containsKey((Object)entity.getType())) {
            for (Map.Entry<Class<Entity>, Supplier<IHackableEntity<?>>> entry : this.hackableEntities.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
                this.hackablesByType.put((Object)entity.getType(), entry.getValue().get());
            }
        }
        return this.hackablesByType.get((Object)entity.getType()).stream().filter(hackable -> hackable.canHack(entity, player)).findFirst().orElse(null);
    }

    public Optional<IHackableEntity<?>> getHackableEntityForId(ResourceLocation id) {
        Supplier<IHackableEntity<?>> sup = this.idToEntityHackables.get(id);
        return sup == null ? Optional.empty() : Optional.ofNullable(sup.get());
    }

    public Optional<IHackableBlock> getHackableBlockForId(ResourceLocation id) {
        Supplier<? extends IHackableBlock> sup = this.idToBlockHackables.get(id);
        return sup == null ? Optional.empty() : Optional.ofNullable(sup.get());
    }

    private /* synthetic */ void lambda$resolveBlockTags$0(Supplier hackable, Holder block) {
        this.hackableTaggedBlocks.put((Block)block.value(), hackable);
    }
}

