/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public interface TubeModulePacket<T extends AbstractTubeModule>
extends CustomPacketPayload {
    public static <T extends AbstractTubeModule> void handle(TubeModulePacket<T> message, IPayloadContext ctx) {
        Player player = ctx.player();
        PneumaticCraftUtils.getBlockEntityAt((BlockGetter)player.getCommandSenderWorld(), message.locator().pos(), PressureTubeBlockEntity.class).ifPresent(te -> {
            try {
                AbstractTubeModule tm = te.getModule(message.locator().side());
                if (tm != null && PneumaticCraftUtils.canPlayerReach(player, te.getBlockPos())) {
                    message.onModuleUpdate(tm, player);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    public ModuleLocator locator();

    public void onModuleUpdate(T var1, Player var2);

    public record ModuleLocator(BlockPos pos, Direction side) {
        public static final StreamCodec<FriendlyByteBuf, ModuleLocator> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ModuleLocator::pos, (StreamCodec)Direction.STREAM_CODEC, ModuleLocator::side, ModuleLocator::new);

        public static ModuleLocator forModule(AbstractTubeModule module) {
            return new ModuleLocator(module.getTube().getBlockPos(), module.getDirection());
        }
    }
}

