/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketToggleArmorFeature(FeatureSetting setting) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketToggleArmorFeature> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("toggle_armor_feature"));
    public static final StreamCodec<FriendlyByteBuf, PacketToggleArmorFeature> STREAM_CODEC = StreamCodec.composite(FeatureSetting.STREAM_CODEC, PacketToggleArmorFeature::setting, PacketToggleArmorFeature::new);

    public CustomPacketPayload.Type<PacketToggleArmorFeature> type() {
        return TYPE;
    }

    public static void handle(PacketToggleArmorFeature message, IPayloadContext ctx) {
        EquipmentSlot slot = message.setting().slot();
        byte featureIndex = message.setting.featureIndex();
        boolean state = message.setting.state();
        if (ctx.flow().isClientbound()) {
            ClientUtils.setArmorUpgradeEnabled(slot, featureIndex, state);
        } else if (featureIndex >= 0 && featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).size() && (PneumaticArmorItem.isPneumaticArmorPiece(ctx.player(), slot) || slot == EquipmentSlot.HEAD && featureIndex == 0)) {
            CommonArmorHandler.getHandlerForPlayer(ctx.player()).setUpgradeEnabled(slot, featureIndex, state);
        }
    }

    public record FeatureSetting(EquipmentSlot slot, byte featureIndex, boolean state) {
        public static final StreamCodec<FriendlyByteBuf, FeatureSetting> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(EquipmentSlot.class), FeatureSetting::slot, (StreamCodec)ByteBufCodecs.BYTE, FeatureSetting::featureIndex, (StreamCodec)ByteBufCodecs.BOOL, FeatureSetting::state, FeatureSetting::new);
    }
}

