/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketShowWireframe(BlockPos pos, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketShowWireframe> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("show_wireframe"));
    public static final StreamCodec<FriendlyByteBuf, PacketShowWireframe> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketShowWireframe::pos, (StreamCodec)ByteBufCodecs.INT, PacketShowWireframe::entityId, PacketShowWireframe::new);

    public static PacketShowWireframe forDrone(DroneEntity entity, BlockPos pos) {
        return new PacketShowWireframe(pos, entity.getId());
    }

    public static PacketShowWireframe fromNetwork(FriendlyByteBuf buffer) {
        return new PacketShowWireframe(buffer.readBlockPos(), buffer.readInt());
    }

    public CustomPacketPayload.Type<PacketShowWireframe> type() {
        return TYPE;
    }

    public static void handle(PacketShowWireframe message, IPayloadContext ctx) {
        Entity entity = ctx.player().level().getEntity(message.entityId());
        if (entity instanceof DroneEntity) {
            DroneEntity drone = (DroneEntity)entity;
            EntityTrackerClientHandler.addDroneToHudHandler(drone, message.pos());
        }
    }
}

