/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.gui.remote.AbstractRemoteScreen;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSetGlobalVariable(String varName, Either<Optional<BlockPos>, ItemStack> value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSetGlobalVariable> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("set_global_variable"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetGlobalVariable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PacketSetGlobalVariable::varName, (StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC), PacketSetGlobalVariable::value, PacketSetGlobalVariable::new);

    public static PacketSetGlobalVariable forPos(String varName, @Nullable BlockPos value) {
        if (!GlobalVariableHelper.getInstance().hasPrefix((String)varName)) {
            varName = "#" + (String)varName;
        }
        return new PacketSetGlobalVariable((String)varName, (Either<Optional<BlockPos>, ItemStack>)Either.left(Optional.ofNullable(value)));
    }

    public static PacketSetGlobalVariable forItem(String varName, @Nonnull ItemStack stack) {
        if (!GlobalVariableHelper.getInstance().hasPrefix((String)varName)) {
            varName = "#" + (String)varName;
        }
        return new PacketSetGlobalVariable((String)varName, (Either<Optional<BlockPos>, ItemStack>)Either.right((Object)stack));
    }

    public static PacketSetGlobalVariable forInt(String varName, int value) {
        return PacketSetGlobalVariable.forPos(varName, new BlockPos(value, 0, 0));
    }

    public static PacketSetGlobalVariable forBool(String varName, boolean value) {
        return PacketSetGlobalVariable.forInt(varName, value ? 1 : 0);
    }

    public CustomPacketPayload.Type<PacketSetGlobalVariable> type() {
        return TYPE;
    }

    public static void handle(PacketSetGlobalVariable message, IPayloadContext ctx) {
        Player player = ctx.player();
        message.value().ifLeft(pos -> GlobalVariableHelper.getInstance().setPos(player.getUUID(), message.varName(), pos.orElse(null))).ifRight(stack -> GlobalVariableHelper.getInstance().setStack(player.getUUID(), message.varName(), (ItemStack)stack));
        if (ctx.flow().isClientbound()) {
            AbstractRemoteScreen.handleVariableChangeIfOpen(message.varName());
            AreaRenderManager.getInstance().clearPosProviderCache();
        }
    }
}

