/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketHackingEntityFinish(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketHackingEntityFinish> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("hack_entity_finish"));
    public static final StreamCodec<FriendlyByteBuf, PacketHackingEntityFinish> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketHackingEntityFinish::entityId, PacketHackingEntityFinish::new);

    public static PacketHackingEntityFinish forEntity(Entity entity) {
        return new PacketHackingEntityFinish(entity.getId());
    }

    public CustomPacketPayload.Type<PacketHackingEntityFinish> type() {
        return TYPE;
    }

    public static void handle(PacketHackingEntityFinish message, IPayloadContext ctx) {
        IHackableEntity<?> hackableEntity;
        Player player = ctx.player();
        Entity entity = player.level().getEntity(message.entityId());
        if (entity != null && (hackableEntity = HackManager.getHackableForEntity(entity, player)) != null) {
            hackableEntity._onHackFinished(entity, player);
            HackTickTracker.getInstance(entity.level()).trackEntity(entity, hackableEntity);
            CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(null);
            player.playSound((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
        }
    }
}

