/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketHackingBlockStart(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketHackingBlockStart> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("hack_block_start"));
    public static final StreamCodec<FriendlyByteBuf, PacketHackingBlockStart> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketHackingBlockStart::pos, PacketHackingBlockStart::new);

    public CustomPacketPayload.Type<PacketHackingBlockStart> type() {
        return TYPE;
    }

    public static void handle(PacketHackingBlockStart message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (ctx.flow().isClientbound()) {
            CommonArmorHandler.getHandlerForPlayer().getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)message.pos));
            RenderBlockTarget target = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(message.pos);
            if (target != null) {
                target.onHackConfirmedByServer();
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.blockTrackerHandler, true)) {
                handler.getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)message.pos));
                NetworkHandler.sendToPlayer(message, sp);
            }
        }
    }
}

