/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketAmadronTradeAddCustom(AmadronPlayerOffer offer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketAmadronTradeAddCustom> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("amadron_add_custom_trade"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketAmadronTradeAddCustom> STREAM_CODEC = StreamCodec.composite(AmadronPlayerOffer.STREAM_CODEC, PacketAmadronTradeAddCustom::offer, PacketAmadronTradeAddCustom::new);

    public static void handle(PacketAmadronTradeAddCustom message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            message.handleClientSide(ctx.player());
        } else {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                message.handleServerSide(sp);
            }
        }
    }

    public CustomPacketPayload.Type<PacketAmadronTradeAddCustom> type() {
        return TYPE;
    }

    private void handleClientSide(Player player) {
        if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.amadron.playerAddedTrade", (Object[])new Object[]{this.offer.getVendorName(), this.offer.getOutput().toString(), this.offer.getInput().toString()}), false);
        }
    }

    private void handleServerSide(ServerPlayer player) {
        if (player.containerMenu instanceof AmadronAddTradeMenu) {
            this.offer.updatePlayerId();
            if (AmadronOfferManager.getInstance().hasSimilarPlayerOffer(this.offer.getReversedOffer())) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateReversedOffer", new Object[0]), false);
            } else if (AmadronOfferManager.getInstance().addPlayerOffer(this.offer)) {
                if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
                    NetworkHandler.sendToAll(this);
                }
                if (player.getMainHandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui(player, InteractionHand.MAIN_HAND);
                } else if (player.getOffhandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui(player, InteractionHand.OFF_HAND);
                }
            } else {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateOffer", new Object[0]), false);
            }
        }
    }
}

