/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AirCanisterItem
extends PressurizableItem {
    private final CanisterType type;

    public AirCanisterItem(CanisterType type) {
        super(ModItems.defaultProps().component(ModDataComponents.AIR_CANISTER_CHARGING, (Object)ChargeMode.NONE), type.maxAir, type.volume);
        this.type = type;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getPressure(stack) > 0.0f ? 1 : super.getMaxStackSize(stack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        MutableComponent c = PneumaticCraftUtils.xlate(((ChargeMode)pStack.getOrDefault(ModDataComponents.AIR_CANISTER_CHARGING, (Object)ChargeMode.NONE)).getTranslationKey(), new Object[0]);
        pTooltipComponents.add((Component)c.withStyle(ChatFormatting.AQUA));
        pTooltipComponents.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.air_canister.charging.sneak_right_click", new Object[0]).withStyle(ChatFormatting.GREEN));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide) {
            ChargeMode mode = AirCanisterItem.getChargeMode(stack).nextMode();
            pPlayer.getItemInHand(pUsedHand).set(ModDataComponents.AIR_CANISTER_CHARGING, (Object)mode);
            pPlayer.displayClientMessage((Component)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA), true);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide);
    }

    @Override
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity.level().isClientSide) {
            return;
        }
        ChargeMode mode = AirCanisterItem.getChargeMode(pStack);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (mode != ChargeMode.NONE && pLevel.getGameTime() % 20L == 15L) {
                PNCCapabilities.getAirHandler(pStack).ifPresent(srcHandler -> {
                    if (mode == ChargeMode.HELD) {
                        this.tryChargeItem((IAirHandler)srcHandler, player.getMainHandItem(), this.type.maxTransfer);
                    } else {
                        for (ItemStack stack : player.getInventory().items) {
                            if (srcHandler.getPressure() < 0.1f) break;
                            if (stack.getCount() != 1 || stack == pStack || AirCanisterItem.isChargingAirCanister(stack)) continue;
                            this.tryChargeItem((IAirHandler)srcHandler, stack, this.type.maxTransfer);
                        }
                    }
                });
            }
        }
    }

    private static boolean isChargingAirCanister(ItemStack stack) {
        return stack.getItem() instanceof AirCanisterItem && AirCanisterItem.getChargeMode(stack) != ChargeMode.NONE;
    }

    private void tryChargeItem(IAirHandler srcHandler, ItemStack dstStack, int maxAir) {
        PNCCapabilities.getAirHandler(dstStack).ifPresent(destHandler -> {
            float destPressure = destHandler.getPressure();
            if (destPressure < destHandler.maxPressure() && destPressure - srcHandler.getPressure() < -0.01f) {
                float targetPressure = Math.min((srcHandler.getPressure() + destHandler.getPressure()) / 2.0f, destHandler.maxPressure());
                int currentAir = destHandler.getAir();
                int targetAir = (int)(targetPressure * (float)destHandler.getVolume());
                int airToMove = Mth.clamp((int)(targetAir - currentAir), (int)0, (int)maxAir);
                destHandler.addAir(airToMove);
                srcHandler.addAir(-airToMove);
            }
        });
    }

    public boolean isFoil(ItemStack pStack) {
        return AirCanisterItem.getChargeMode(pStack) != ChargeMode.NONE;
    }

    public static ChargeMode getChargeMode(ItemStack stack) {
        return (ChargeMode)stack.getOrDefault(ModDataComponents.AIR_CANISTER_CHARGING, (Object)ChargeMode.NONE);
    }

    public static enum ChargeMode implements StringRepresentable,
    ITranslatableEnum
    {
        NONE("none"),
        HELD("held"),
        ALL("all");

        private final String name;

        private ChargeMode(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.air_canister.charging." + this.name;
        }

        public ChargeMode nextMode() {
            return ChargeMode.values()[(this.ordinal() + 1) % ChargeMode.values().length];
        }
    }

    public static enum CanisterType {
        BASIC(30000, 3000, 1000),
        BASIC_ARRAY(120000, 12000, 4000),
        REINFORCED(240000, 12000, 4000),
        REINFORCED_ARRAY(960000, 48000, 16000);

        private final int maxAir;
        private final int volume;
        private final int maxTransfer;

        private CanisterType(int maxAir, int volume, int maxTransfer) {
            this.maxAir = maxAir;
            this.volume = volume;
            this.maxTransfer = maxTransfer;
        }
    }
}

