/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IActiveEntityHacks;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.hacking.block.HackableButton;
import me.desht.pneumaticcraft.common.hacking.block.HackableDispenser;
import me.desht.pneumaticcraft.common.hacking.block.HackableDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableJukebox;
import me.desht.pneumaticcraft.common.hacking.block.HackableLever;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.hacking.block.HackableNoteblock;
import me.desht.pneumaticcraft.common.hacking.block.HackableSecurityStation;
import me.desht.pneumaticcraft.common.hacking.block.HackableSilverfish;
import me.desht.pneumaticcraft.common.hacking.block.HackableTNT;
import me.desht.pneumaticcraft.common.hacking.block.HackableTrapDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableTripwire;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBat;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBlaze;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCaveSpider;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCow;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCreeper;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGhast;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGuardian;
import me.desht.pneumaticcraft.common.hacking.entity.HackableHorse;
import me.desht.pneumaticcraft.common.hacking.entity.HackableItemFrame;
import me.desht.pneumaticcraft.common.hacking.entity.HackableMobDisarm;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePainting;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePufferfish;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSheep;
import me.desht.pneumaticcraft.common.hacking.entity.HackableShulker;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSquid;
import me.desht.pneumaticcraft.common.hacking.entity.HackableTameable;
import me.desht.pneumaticcraft.common.hacking.entity.HackableVillager;
import me.desht.pneumaticcraft.common.hacking.entity.HackableWitch;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModAttachmentTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class HackManager {
    private static HackManager clientInstance;
    private static HackManager serverInstance;
    private final Map<Entity, IHackableEntity<?>> hackableEntities = new HashMap();
    private final Map<GlobalPos, Pair<Block, IHackableBlock>> hackableBlocks = new HashMap<GlobalPos, Pair<Block, IHackableBlock>>();
    private long lastEntityPrune = 0L;
    private long lastBlockPrune = 0L;

    private static HackManager getInstance(Level world) {
        if (world.isClientSide) {
            if (clientInstance == null) {
                clientInstance = new HackManager();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackManager();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        ICommonArmorRegistry registry = PneumaticRegistry.getInstance().getCommonArmorRegistry();
        registry.addHackable(Blocks.TNT, HackableTNT::new);
        registry.addHackable(Blocks.SPAWNER, HackableMobSpawner::new);
        registry.addHackable(Blocks.LEVER, HackableLever::new);
        registry.addHackable(Blocks.TRIPWIRE_HOOK, HackableTripwire::new);
        registry.addHackable(Blocks.DISPENSER, HackableDispenser::new);
        registry.addHackable(Blocks.DROPPER, HackableDispenser::new);
        registry.addHackable((Block)ModBlocks.SECURITY_STATION.get(), HackableSecurityStation::new);
        registry.addHackable(Blocks.INFESTED_COBBLESTONE, HackableSilverfish::new);
        registry.addHackable(Blocks.INFESTED_CHISELED_STONE_BRICKS, HackableSilverfish::new);
        registry.addHackable(Blocks.INFESTED_CRACKED_STONE_BRICKS, HackableSilverfish::new);
        registry.addHackable(Blocks.INFESTED_MOSSY_STONE_BRICKS, HackableSilverfish::new);
        registry.addHackable(Blocks.INFESTED_STONE, HackableSilverfish::new);
        registry.addHackable(Blocks.INFESTED_STONE_BRICKS, HackableSilverfish::new);
        registry.addHackable(Blocks.NOTE_BLOCK, HackableNoteblock::new);
        registry.addHackable(Blocks.JUKEBOX, HackableJukebox::new);
        registry.addHackable((TagKey<Block>)BlockTags.BUTTONS, HackableButton::new);
        registry.addHackable((TagKey<Block>)BlockTags.DOORS, HackableDoor::new);
        registry.addHackable((TagKey<Block>)BlockTags.TRAPDOORS, HackableTrapDoor::new);
        registry.addHackable(Mob.class, HackableMobDisarm::new);
        registry.addHackable(Creeper.class, HackableCreeper::new);
        registry.addHackable(TamableAnimal.class, HackableTameable::new);
        registry.addHackable(Cow.class, HackableCow::new);
        registry.addHackable(Sheep.class, HackableSheep::new);
        registry.addHackable(CaveSpider.class, HackableCaveSpider::new);
        registry.addHackable(Blaze.class, HackableBlaze::new);
        registry.addHackable(Ghast.class, HackableGhast::new);
        registry.addHackable(Witch.class, HackableWitch::new);
        registry.addHackable(EnderMan.class, HackableEnderman::new);
        registry.addHackable(Bat.class, HackableBat::new);
        registry.addHackable(Horse.class, HackableHorse::new);
        registry.addHackable(Shulker.class, HackableShulker::new);
        registry.addHackable(Guardian.class, HackableGuardian::new);
        registry.addHackable(Pufferfish.class, HackablePufferfish::new);
        registry.addHackable(Squid.class, HackableSquid::new);
        registry.addHackable(Villager.class, HackableVillager::new);
        registry.addHackable(Painting.class, HackablePainting::new);
        registry.addHackable(ItemFrame.class, HackableItemFrame::new);
    }

    public static IHackableEntity<?> getHackableForEntity(Entity entity, Player player) {
        IHackableEntity h;
        HackManager manager = HackManager.getInstance(player.level());
        if (player.level().getGameTime() - 60L > manager.lastEntityPrune) {
            manager.hackableEntities.entrySet().removeIf(entry -> !((Entity)entry.getKey()).isAlive() || !((IHackableEntity)entry.getValue()).canHack((Entity)entry.getKey(), player) && !HackManager.isInDisplayCooldown((IHackableEntity)entry.getValue(), (Entity)entry.getKey()));
            manager.lastEntityPrune = player.level().getGameTime();
        }
        if (entity instanceof IHackableEntity && (h = (IHackableEntity)entity).canHack(entity, player)) {
            return h;
        }
        IHackableEntity<?> hackable = manager.hackableEntities.get(entity);
        if (hackable == null && (hackable = CommonArmorRegistry.getInstance().getHackable(entity, player)) != null) {
            manager.hackableEntities.put(entity, hackable);
        }
        return hackable;
    }

    public static IHackableBlock getHackableForBlock(Level blockGetter, BlockPos pos, Player player) {
        IHackableBlock h;
        BlockState state = blockGetter.getBlockState(pos);
        Block block = state.getBlock();
        HackManager manager = HackManager.getInstance(player.level());
        MinecraftServer server = blockGetter.getServer();
        if (player.level().getGameTime() - 60L > manager.lastBlockPrune) {
            manager.hackableBlocks.entrySet().removeIf(entry -> {
                Block trackedBlock = (Block)((Pair)entry.getValue()).getLeft();
                IHackableBlock hackableBlock = (IHackableBlock)((Pair)entry.getValue()).getRight();
                if (server == null && !blockGetter.dimension().equals(((GlobalPos)entry.getKey()).dimension())) {
                    return false;
                }
                Level level = server == null ? blockGetter : server.getLevel(((GlobalPos)entry.getKey()).dimension());
                return block != trackedBlock || level == null || !hackableBlock.canHack((BlockGetter)level, ((GlobalPos)entry.getKey()).pos(), state, player) && !HackManager.isInDisplayCooldown(hackableBlock, (BlockGetter)level, ((GlobalPos)entry.getKey()).pos(), player);
            });
            manager.lastBlockPrune = player.level().getGameTime();
        }
        if (block instanceof IHackableBlock && (h = (IHackableBlock)block).canHack((BlockGetter)blockGetter, pos, state, player)) {
            return h;
        }
        GlobalPos gpos = GlobalPos.of((ResourceKey)blockGetter.dimension(), (BlockPos)pos);
        Pair pair = manager.hackableBlocks.get(gpos);
        if (pair == null) {
            IHackableBlock hackable = CommonArmorRegistry.getInstance().getHackable(block);
            if (hackable != null && hackable.canHack((BlockGetter)blockGetter, pos, state, player)) {
                pair = Pair.of((Object)block, (Object)hackable);
                manager.hackableBlocks.put(gpos, (Pair<Block, IHackableBlock>)pair);
            } else {
                return null;
            }
        }
        return (IHackableBlock)pair.getRight();
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, BlockGetter world, BlockPos pos, Player player) {
        if (player.level().isClientSide) {
            RenderBlockTarget target = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(pos);
            int requiredHackTime = hackableBlock.getHackTime(world, pos, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity<?> hackableEntity, Entity entity) {
        if (entity.level().isClientSide) {
            RenderEntityTarget target = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableEntity._getHackTime(entity, ClientUtils.getClientPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    public static Optional<? extends IActiveEntityHacks> getActiveHacks(Entity entity) {
        return entity.getExistingData(ModAttachmentTypes.HACKING.get());
    }

    public static Optional<? extends IActiveEntityHacks> getOrCreateActiveHacks(Entity entity) {
        return Optional.of((IActiveEntityHacks)entity.getData(ModAttachmentTypes.HACKING.get()));
    }
}

