/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypeSphere
extends AreaType {
    public static final MapCodec<AreaTypeSphere> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(SphereType::values).optionalFieldOf("sphere_type", (Object)SphereType.FILLED).forGetter(t -> t.sphereType)).apply((Applicative)builder, AreaTypeSphere::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeSphere> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(SphereType.class), t -> t.sphereType, AreaTypeSphere::new);
    public static final String ID = "sphere";
    private SphereType sphereType;

    public AreaTypeSphere() {
        this(SphereType.FILLED);
    }

    public AreaTypeSphere(SphereType sphereType) {
        super(ID);
        this.sphereType = sphereType;
    }

    @Override
    public AreaType copy() {
        return new AreaTypeSphere(this.sphereType);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.sphereType);
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_SPHERE.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        double radius = PneumaticCraftUtils.distBetween((Vec3i)p1, (Vec3i)p2);
        double radiusSq = radius * radius;
        double innerRadius = this.sphereType == SphereType.HOLLOW ? radius - 1.0 : 0.0;
        double innerRadiusSq = innerRadius * innerRadius;
        minX = (int)((double)p1.getX() - radius - 1.0);
        minY = (int)((double)p1.getY() - radius - 1.0);
        minZ = (int)((double)p1.getZ() - radius - 1.0);
        maxX = (int)((double)p1.getX() + radius + 1.0);
        maxY = (int)((double)p1.getY() + radius + 1.0);
        maxZ = (int)((double)p1.getZ() + radius + 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double centerDistSq = PneumaticCraftUtils.distBetweenSq((Vec3i)p1, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (!(centerDistSq <= radiusSq) || !(centerDistSq >= innerRadiusSq)) continue;
                    areaAdder.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<SphereType>("pneumaticcraft.gui.progWidget.area.type.sphere.sphereType", SphereType.class, () -> this.sphereType, sphereType -> {
            this.sphereType = sphereType;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeSphere that = (AreaTypeSphere)o;
        return this.sphereType == that.sphereType;
    }

    public int hashCode() {
        return Objects.hashCode(this.sphereType);
    }

    public static enum SphereType implements ITranslatableEnum,
    StringRepresentable
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private SphereType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.sphere.sphereType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

