/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetJump
extends ProgWidget
implements IJump {
    public static final MapCodec<ProgWidgetJump> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetJump.baseParts(builder).apply((Applicative)builder, ProgWidgetJump::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetJump> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetJump::new);

    public ProgWidgetJump(ProgWidget.PositionFields pos) {
        super(pos);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetJump(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.JUMP.get();
    }

    public ProgWidgetJump() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.label.error.noJumpLocation", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public boolean hasStepOutput() {
        return false;
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        ProgWidgetText jumpedLabel = (ProgWidgetText)this.getConnectedParameters()[0];
        if (jumpedLabel != null) {
            IDroneBase.asDroneBase(drone).getAIManager().setLabel(jumpedLabel.string);
            IProgWidget widget = ProgWidgetJump.jumpToLabel(drone, allWidgets, jumpedLabel.string);
            if (widget != null) {
                return widget;
            }
        }
        drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.jump.nowhereToJump");
        return null;
    }

    static IProgWidget jumpToLabel(IDrone drone, List<IProgWidget> allWidgets, IProgWidget conditionWidget, boolean conditionValue) {
        ProgWidgetText textWidget = (ProgWidgetText)(conditionValue ? conditionWidget.getConnectedParameters()[conditionWidget.getParameters().size() - 1] : conditionWidget.getConnectedParameters()[conditionWidget.getParameters().size() * 2 - 1]);
        if (textWidget != null) {
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, textWidget.string);
        }
        IProgWidget widget = conditionWidget.getOutputWidget();
        if (widget == null) {
            drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.jump.nowhereToJump");
        }
        return widget;
    }

    static IProgWidget jumpToLabel(IDrone drone, List<IProgWidget> allWidgets, String label) {
        IDroneBase.asDroneBase(drone).getAIManager().setLabel(label);
        ArrayList<IProgWidget> possibleJumpLocations = new ArrayList<IProgWidget>();
        for (IProgWidget widget : allWidgets) {
            String labelLabel;
            if (!(widget instanceof ILabel) || (labelLabel = ((ILabel)((Object)widget)).getLabel()) == null || !labelLabel.equals(label)) continue;
            possibleJumpLocations.add(widget);
        }
        if (possibleJumpLocations.isEmpty()) {
            drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.jump.nowhereToJump");
            return null;
        }
        return (IProgWidget)possibleJumpLocations.get(ThreadLocalRandom.current().nextInt(possibleJumpLocations.size()));
    }

    @Override
    public IProgWidget getOutputWidget() {
        return null;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_JUMP;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        ProgWidgetText jumpedLabel = (ProgWidgetText)this.getConnectedParameters()[0];
        if (jumpedLabel != null) {
            return Collections.singletonList(jumpedLabel.string);
        }
        return Collections.emptyList();
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }
}

