/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIExternalProgram;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetExternalProgram
extends ProgWidgetAreaItemBase {
    public static final MapCodec<ProgWidgetExternalProgram> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetExternalProgram.baseParts(builder).and((App)Codec.BOOL.optionalFieldOf("share_variables", (Object)false).forGetter(ProgWidgetExternalProgram::isShareVariables)).apply((Applicative)builder, ProgWidgetExternalProgram::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetExternalProgram> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetExternalProgram::isShareVariables, ProgWidgetExternalProgram::new);
    public boolean shareVariables;

    private ProgWidgetExternalProgram(ProgWidget.PositionFields pos, boolean shareVariables) {
        super(pos);
        this.shareVariables = shareVariables;
    }

    public ProgWidgetExternalProgram() {
        this(ProgWidget.PositionFields.DEFAULT, false);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetExternalProgram(this.getPosition(), this.shareVariables);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EXTERNAL_PROGRAM;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.EXTERNAL_PROGRAM.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIExternalProgram(drone, this.aiManager, (ProgWidgetExternalProgram)widget);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    public boolean isShareVariables() {
        return this.shareVariables;
    }

    @Override
    public boolean canBeRunByComputers(IDrone drone, IProgWidget widget) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetExternalProgram that = (ProgWidgetExternalProgram)o;
        return this.baseEquals(that) && this.shareVariables == that.shareVariables;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.shareVariables);
    }
}

