/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.ICustomBlockInteract;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IDroneRegistry;
import me.desht.pneumaticcraft.api.drone.IPathfindHandler;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCustomBlockInteract;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.ProgrammedDroneUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;

public enum DroneRegistry implements IDroneRegistry
{
    INSTANCE;

    public final Map<Block, IPathfindHandler> pathfindableBlocks = new HashMap<Block, IPathfindHandler>();

    public static DroneRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void addPathfindableBlock(Block block, IPathfindHandler handler) {
        this.pathfindableBlocks.put(Objects.requireNonNull(block), handler);
    }

    @Override
    public void registerCustomBlockInteractor(ICustomBlockInteract interactor) {
        ModProgWidgetTypes.PROG_WIDGETS_DEFERRED.register(interactor.getID(), () -> ProgWidgetType.createType(() -> new ProgWidgetCustomBlockInteract().setInteractor(interactor), ProgWidgetCustomBlockInteract.CODEC, ProgWidgetCustomBlockInteract.STREAM_CODEC));
    }

    @Override
    public PathfinderMob deliverItemsAmazonStyle(GlobalPos globalPos, ItemStack ... deliveredStacks) {
        return ProgrammedDroneUtils.deliverItemsAmazonStyle(globalPos, deliveredStacks);
    }

    @Override
    public PathfinderMob retrieveItemsAmazonStyle(GlobalPos globalPos, ItemStack ... queriedStacks) {
        return ProgrammedDroneUtils.retrieveItemsAmazonStyle(globalPos, queriedStacks);
    }

    @Override
    public PathfinderMob deliverFluidAmazonStyle(GlobalPos globalPos, FluidStack deliveredFluid) {
        return ProgrammedDroneUtils.deliverFluidAmazonStyle(globalPos, deliveredFluid);
    }

    @Override
    public PathfinderMob retrieveFluidAmazonStyle(GlobalPos globalPos, FluidStack queriedFluid) {
        return ProgrammedDroneUtils.retrieveFluidAmazonStyle(globalPos, queriedFluid);
    }

    @Override
    public Optional<IDrone> getDrone(Level level, int entityID) {
        Optional<IDrone> optional;
        Entity e = level.getEntity(entityID);
        if (e instanceof IDrone) {
            IDrone d = (IDrone)e;
            optional = Optional.of(d);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<IDrone> getDrone(Level level, BlockPos pos) {
        Optional<IDrone> optional;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IDrone) {
            IDrone d = (IDrone)be;
            optional = Optional.of(d);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

