/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DisplayTableBlockEntity
extends AbstractPneumaticCraftBlockEntity
implements IComparatorSupport {
    private final DisplayItemHandler inventory = new DisplayItemHandler(this, 1);
    public ItemStack displayedStack = ItemStack.EMPTY;

    public DisplayTableBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.DISPLAY_TABLE.get(), pos, state);
    }

    DisplayTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        tag.put("Item", this.displayedStack.saveOptional(provider));
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        this.displayedStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Item"));
        this.inventory.initStack(this.displayedStack);
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getStackInSlot(0).isEmpty() ? 0 : 15;
    }

    class DisplayItemHandler
    extends BaseItemStackHandler {
        DisplayItemHandler(DisplayTableBlockEntity te, int size) {
            super(te, size);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                DisplayTableBlockEntity.this.displayedStack = this.getStackInSlot(0);
                if (!DisplayTableBlockEntity.this.nonNullLevel().isClientSide) {
                    DisplayTableBlockEntity.this.sendDescriptionPacket();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        private void initStack(ItemStack stack) {
            this.stacks.set(0, (Object)stack);
        }
    }
}

