/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class SideConfigurator<T> {
    public static final String BASE_BUTTON_TAG = "SideConf";
    private final List<ConnectionEntry<T>> entries = new ArrayList<ConnectionEntry<T>>();
    private final String id;
    private final ISideConfigurable sideConfigurable;
    private final Map<String, Integer> idxMap = new HashMap<String, Integer>();
    private Supplier<T> nullFaceHandler = () -> null;
    private final Map<RelativeFace, Integer> faces = new EnumMap<RelativeFace, Integer>(RelativeFace.class);
    private final Map<RelativeFace, Integer> defaultFaces = new EnumMap<RelativeFace, Integer>(RelativeFace.class);
    private final RelativeFace[][] facingMatrix = new RelativeFace[4][];
    public static final Codec<Map<String, Saved>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Saved.CODEC);
    public static final StreamCodec<FriendlyByteBuf, Map<String, Saved>> STREAM_CODEC = ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ByteBufCodecs.STRING_UTF8, Saved.STREAM_CODEC);

    public SideConfigurator(String id, ISideConfigurable sideConfigurable) {
        this.id = id;
        this.sideConfigurable = sideConfigurable;
        this.entries.add(null);
        this.setupFacingMatrix();
    }

    public int registerHandler(String id, ItemStack textureStack, BaseCapability<T, ?> cap, Supplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, (Either<ItemStack, ResourceLocation>)Either.left((Object)textureStack), cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public int registerHandler(String id, ResourceLocation texture, BaseCapability<T, ?> cap, Supplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, (Either<ItemStack, ResourceLocation>)Either.right((Object)texture), cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    private int setDefaultSides(RelativeFace ... defaultRelativeFaces) {
        Validate.isTrue((this.entries.size() <= 127 ? 1 : 0) != 0, (String)"No more than 127 entries allowed", (Object[])new Object[0]);
        int idx = this.entries.size() - 1;
        for (RelativeFace relativeFace : defaultRelativeFaces) {
            this.faces.put(relativeFace, idx);
            this.defaultFaces.put(relativeFace, idx);
        }
        return idx;
    }

    public void setNullFaceHandler(String id) {
        this.nullFaceHandler = this.entries.get((int)this.idxMap.get((Object)id).intValue()).handler;
    }

    private boolean shouldSaveNBT() {
        return !this.faces.equals(this.defaultFaces);
    }

    public void updateHandler(String id, Supplier<T> handler) {
        int idx = this.idxMap.get(id);
        ConnectionEntry<T> e = this.entries.get(idx);
        this.entries.set(idx, new ConnectionEntry(e.id, e.texture, e.cap, handler));
    }

    public boolean handleButtonPress(String tag, boolean hasShiftDown) {
        if (tag.startsWith(BASE_BUTTON_TAG)) {
            try {
                RelativeFace relativeFace = RelativeFace.valueOf(tag.split("\\.")[1]);
                this.cycleValue(relativeFace, hasShiftDown);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getButtonTag(RelativeFace relativeFace) {
        return "SideConf." + relativeFace.toString();
    }

    private void cycleValue(RelativeFace relativeFace, boolean hasShiftDown) {
        int n = 0;
        while (n++ < this.entries.size()) {
            this.cycleFace(relativeFace, hasShiftDown ? -1 : 1);
            ConnectionEntry<T> c = this.entries.get(this.getFaceIndex(relativeFace));
            if (!this.sideConfigurable.isValid(relativeFace, c == null ? null : c.handler.get())) continue;
            return;
        }
    }

    private void cycleFace(RelativeFace idx, int dir) {
        int newVal = this.getFaceIndex(idx) + dir;
        if (newVal < 0) {
            newVal = this.entries.size() - 1;
        } else if (newVal >= this.entries.size()) {
            newVal = 0;
        }
        this.faces.put(idx, newVal);
    }

    public String getID() {
        return this.id;
    }

    public String getTranslationKey() {
        return "pneumaticcraft.gui.sideConfigurator.title." + this.id;
    }

    public T getHandler(Direction facing) {
        if (facing == null) {
            return this.nullFaceHandler.get();
        }
        ConnectionEntry<T> c = this.entries.get(this.getFaceIndex(this.getRelativeFace(facing)));
        return c == null ? null : (T)c.handler.get();
    }

    void setupFacingMatrix() {
        for (Direction f : DirectionUtil.HORIZONTALS) {
            this.facingMatrix[f.get2DDataValue()] = new RelativeFace[4];
            for (RelativeFace rf : RelativeFace.HORIZONTALS) {
                Direction f2 = this.rot(f, rf);
                this.facingMatrix[f.get2DDataValue()][f2.get2DDataValue()] = rf;
            }
        }
    }

    private Direction rot(Direction in, RelativeFace rf) {
        return switch (rf.ordinal()) {
            case 3 -> in.getCounterClockWise();
            case 2 -> in.getClockWise();
            case 5 -> in.getOpposite();
            default -> in;
        };
    }

    private RelativeFace getRelativeFace(Direction facing) {
        if (facing == Direction.UP) {
            return RelativeFace.TOP;
        }
        if (facing == Direction.DOWN) {
            return RelativeFace.BOTTOM;
        }
        return this.facingMatrix[this.sideConfigurable.byIndex().get2DDataValue()][facing.get2DDataValue()];
    }

    public Component getFaceLabel(RelativeFace relativeFace) {
        ConnectionEntry<T> c = this.entries.get(this.getFaceIndex(relativeFace));
        return c == null ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator.unconnected", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator." + this.id + "." + c.id, new Object[0]);
    }

    public ConnectionEntry<?> getEntry(RelativeFace relativeFace) {
        return this.entries.get(this.getFaceIndex(relativeFace));
    }

    private int getFaceIndex(RelativeFace relativeFace) {
        return this.faces.getOrDefault((Object)relativeFace, 0);
    }

    public static Tag writeToNBT(ISideConfigurable sideConfigurable, HolderLookup.Provider provider) {
        Map<String, Saved> saveMap = SideConfigurator.buildSavedMap(sideConfigurable);
        return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), saveMap).resultOrPartial(err -> Log.error("can't encode side config: {}", err)).orElse(new CompoundTag());
    }

    public static void readFromNBT(CompoundTag tag, ISideConfigurable sideConfigurable, HolderLookup.Provider provider) {
        CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(err -> Log.error("can't decode side config: {}", err)).ifPresent(data -> SideConfigurator.loadSavedData(sideConfigurable, data));
    }

    @NotNull
    public static Map<String, Saved> buildSavedMap(ISideConfigurable sideConfigurable) {
        return sideConfigurable.getSideConfigurators().stream().filter(SideConfigurator::shouldSaveNBT).collect(Collectors.toMap(sc -> sc.id, Saved::fromConfigurator, (a, b) -> b));
    }

    public static void loadSavedData(ISideConfigurable sideConfigurable, Map<String, Saved> saveMap) {
        sideConfigurable.getSideConfigurators().stream().filter(sc -> saveMap.containsKey(sc.id)).forEach(sc -> ((Saved)saveMap.get(sc.id)).loadInto((SideConfigurator<?>)sc));
    }

    public static enum RelativeFace implements StringRepresentable
    {
        BOTTOM("bottom"),
        TOP("top"),
        LEFT("left"),
        RIGHT("right"),
        FRONT("front"),
        BACK("back");

        public static final RelativeFace[] HORIZONTALS;
        public static final Codec<RelativeFace> CODEC;
        private final String name;

        private RelativeFace(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            HORIZONTALS = new RelativeFace[4];
            CODEC = StringRepresentable.fromEnum(RelativeFace::values);
            RelativeFace.HORIZONTALS[0] = LEFT;
            RelativeFace.HORIZONTALS[1] = RIGHT;
            RelativeFace.HORIZONTALS[2] = FRONT;
            RelativeFace.HORIZONTALS[3] = BACK;
        }
    }

    public record ConnectionEntry<T>(String id, Either<ItemStack, ResourceLocation> texture, BaseCapability<T, ?> cap, Supplier<T> handler) {
    }

    public record Saved(Map<RelativeFace, Integer> faces) {
        public static final Codec<Saved> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap(RelativeFace.CODEC, (Codec)Codec.INT).fieldOf("faces").forGetter(Saved::faces)).apply((Applicative)builder, Saved::new));
        public static final StreamCodec<FriendlyByteBuf, Saved> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RelativeFace.class), (StreamCodec)ByteBufCodecs.VAR_INT), Saved::faces, Saved::new);

        public static Saved fromConfigurator(SideConfigurator<?> configurator) {
            return new Saved(configurator.faces);
        }

        public void loadInto(SideConfigurator<?> configurator) {
            this.faces.forEach((face, idx) -> configurator.faces.put((RelativeFace)((Object)face), Mth.clamp((int)idx, (int)0, (int)(configurator.entries.size() - 1))));
        }
    }
}

