/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Objects;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

class CachedTileNeighbours {
    private final BitSet known = new BitSet(6);
    private final EnumMap<Direction, WeakReference<BlockEntity>> neighbours = new EnumMap(Direction.class);
    private final BlockEntity owner;

    public CachedTileNeighbours(BlockEntity owner) {
        this.owner = owner;
        for (Direction d : DirectionUtil.VALUES) {
            this.neighbours.put(d, new WeakReference<Object>(null));
        }
    }

    public BlockEntity getCachedNeighbour(Direction dir) {
        BlockEntity res;
        if (this.owner.getLevel() == null) {
            return null;
        }
        BlockEntity blockEntity = res = this.known.get(dir.get3DDataValue()) ? (BlockEntity)this.neighbours.get(dir).get() : this.findNeighbour(dir);
        if (res != null && res.isRemoved()) {
            res = this.findNeighbour(dir);
        }
        return res;
    }

    private BlockEntity findNeighbour(Direction dir) {
        BlockPos pos2 = this.owner.getBlockPos().relative(dir);
        BlockEntity te = Objects.requireNonNull(this.owner.getLevel()).isLoaded(pos2) ? this.owner.getLevel().getBlockEntity(pos2) : null;
        this.neighbours.put(dir, new WeakReference<BlockEntity>(te));
        this.known.set(dir.get3DDataValue());
        return te;
    }

    public void purge() {
        this.known.clear();
    }
}

