/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;

public class ThermalLaggingBlock
extends AbstractPneumaticCraftBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), Block.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5), Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), Block.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public ThermalLaggingBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        EntityCollisionContext ecc;
        Entity entity;
        if (selectionContext instanceof EntityCollisionContext && (entity = (ecc = (EntityCollisionContext)selectionContext).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = livingEntity.getMainHandItem();
            return ModdedWrenchUtils.getInstance().isWrench(stack) || stack.getItem().canPerformAction(stack, ItemAbilities.PICKAXE_DIG) || livingEntity.isCrouching() ? SHAPES[this.getRotation(state).get3DDataValue()] : Shapes.empty();
        }
        return SHAPES[this.getRotation(state).get3DDataValue()];
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.directionProperty(), (Comparable)ctx.getClickedFace().getOpposite());
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction dir = this.getRotation(state);
        return !worldIn.getBlockState(pos.relative(dir)).isAir();
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == state.getBlock();
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }
}

