/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MovingSoundJetBoots
extends AbstractTickableSoundInstance {
    private static final int END_TICKS = 20;
    private static final Vec3 IDLE_VEC = new Vec3(0.0, -0.5, 0.0);
    private final Player player;
    private float targetPitch;
    private int endTimer = Integer.MAX_VALUE;
    private final int nMufflers;

    public MovingSoundJetBoots(Player player) {
        super((SoundEvent)ModSounds.LEAKING_GAS_LOW.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.targetPitch = 0.7f;
        this.pitch = 0.5f;
        this.nMufflers = CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.MUFFLER.get());
        this.volume = this.volumeFromConfig(JetBootsStateTracker.getClientTracker().getJetBootsState(player).isBuilderMode());
        player.setPos(player.getX(), player.getY() + 0.1, player.getZ());
    }

    public void tick() {
        if (!this.player.isAlive()) {
            return;
        }
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(this.player);
        if (this.endTimer == Integer.MAX_VALUE && (!jbState.isEnabled() || !jbState.isActive() && (this.player.onGround() || this.player.isFallFlying()))) {
            this.endTimer = 20;
        }
        if (this.endTimer <= 20) {
            this.endTimer = this.player.onGround() || !jbState.isActive() ? --this.endTimer : Integer.MAX_VALUE;
        }
        this.x = (float)this.player.getX();
        this.y = (float)this.player.getY();
        this.z = (float)this.player.getZ();
        if (this.endTimer > 0 && this.endTimer <= 20) {
            this.targetPitch = 0.5f;
            this.volume = this.volumeFromConfig(jbState.isBuilderMode()) - (float)(20 - this.endTimer) / 50.0f;
        } else {
            if (jbState.isActive()) {
                double vel = this.player.getDeltaMovement().length();
                this.targetPitch = 0.9f + (float)vel / 15.0f;
                this.volume = this.volumeFromConfig(jbState.isBuilderMode()) + (float)vel / 15.0f;
            } else {
                this.targetPitch = 0.9f;
                this.volume = this.volumeFromConfig(jbState.isBuilderMode()) * 0.8f;
            }
            this.handleParticles(jbState.isActive(), jbState.isBuilderMode());
        }
        this.pitch += (this.targetPitch - this.pitch) / 10.0f;
        if (this.player.isInWater()) {
            this.pitch *= 0.75f;
            this.volume *= 0.5f;
        }
    }

    public boolean isStopped() {
        return !this.player.isAlive() || this.endTimer <= 0;
    }

    private void handleParticles(boolean jetBootsActive, boolean builderMode) {
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        if ((jetBootsActive || (this.player.level().getGameTime() & 3L) == 0L || !ClientUtils.isFirstPersonCamera()) && this.player.distanceToSqr((Entity)ClientUtils.getClientPlayer()) < (double)distThresholdSq) {
            Vec3 jetVec;
            int nParticles = jetBootsActive ? 3 : 1;
            Vec3 vec3 = jetVec = jetBootsActive && !builderMode ? this.player.getLookAngle().scale(-0.5) : IDLE_VEC;
            Vec3 feet = jetBootsActive && !builderMode ? this.player.position().add(this.player.getLookAngle().scale(this.player == ClientUtils.getClientPlayer() ? -4.0 : -2.0)) : this.player.position().add(0.0, -0.25, 0.0);
            for (int i = 0; i < nParticles; ++i) {
                ClientUtils.getClientLevel().addParticle((ParticleOptions)AirParticleData.DENSE, feet.x, feet.y, feet.z, jetVec.x, jetVec.y, jetVec.z);
            }
        }
    }

    private float volumeFromConfig(boolean builderMode) {
        return ModUpgrades.getMuffledVolume(builderMode ? ((Double)ConfigHelper.client().sound.jetbootsVolumeBuilderMode.get()).floatValue() : ((Double)ConfigHelper.client().sound.jetbootsVolume.get()).floatValue(), this.nMufflers);
    }
}

