/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.compressor.ManualCompressorBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ManualCompressorRenderer
extends AbstractBlockEntityModelRenderer<ManualCompressorBlockEntity> {
    private final ModelPart pump;
    private final ModelPart pumprod;
    private final ModelPart compressor;
    private final ModelPart base;

    public ManualCompressorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.MANUAL_COMPRESSOR);
        this.pump = root.getChild("pump");
        this.pumprod = root.getChild("pumprod");
        this.compressor = root.getChild("compressor");
        this.base = root.getChild("base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition pump = partdefinition.addOrReplaceChild("pump", CubeListBuilder.create().texOffs(13, 25).addBox(-2.0f, 0.5f, -3.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(1, 27).addBox(-3.0f, 0.5f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(35, 27).addBox(2.0f, 0.5f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(19, 20).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.5f, (float)0.0f));
        PartDefinition pumprod = partdefinition.addOrReplaceChild("pumprod", CubeListBuilder.create().texOffs(21, 9).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition handle_r1 = pumprod.addOrReplaceChild("handle_r1", CubeListBuilder.create().texOffs(12, 3).addBox(-5.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition compressor = partdefinition.addOrReplaceChild("compressor", CubeListBuilder.create().texOffs(62, 29).addBox(-2.0f, -10.0f, 2.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 16).addBox(-3.0f, -11.0f, 3.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 8).addBox(-2.0f, -10.0f, 7.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition support_r1 = compressor.addOrReplaceChild("support_r1", CubeListBuilder.create().texOffs(79, 22).addBox(-0.5f, -1.5f, -0.499f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-4.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition support_r2 = compressor.addOrReplaceChild("support_r2", CubeListBuilder.create().texOffs(51, 22).addBox(-0.5f, -1.5f, -0.499f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-4.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(30, 43).addBox(-5.0f, -3.0f, 4.0f, 10.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 51).addBox(-5.0f, -3.0f, -6.0f, 10.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 42).addBox(3.0f, -2.0f, -8.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(47, 42).addBox(-5.0f, -2.0f, -8.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(22, 63).addBox(-3.0f, -1.0f, -7.0f, 6.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    void renderModel(ManualCompressorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_MANUAL_COMPRESSOR));
        matrixStackIn.translate(0.0f, -0.5625f, 0.0f);
        switch (te.getRotation()) {
            case NORTH: {
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(0.0f));
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(270.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(90.0f));
            }
        }
        matrixStackIn.translate(0.0f, 0.5625f, 0.0f);
        if (te.getLevel().getGameTime() <= te.pumpStepStartTick + 4L) {
            double offset = Mth.lerp((double)partialTicks, (double)te.pumprodVerticalOffsetPreviousTick, (double)te.pumprodVerticalOffsetCurrentTick);
            matrixStackIn.translate(0.0, offset / 16.0, 0.0);
        } else {
            matrixStackIn.translate(0.0, te.pumprodVerticalOffsetCurrent / 16.0, 0.0);
        }
        this.pumprod.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }
}

