/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class AssemblyControllerRenderer
extends AbstractBlockEntityModelRenderer<AssemblyControllerBlockEntity> {
    private static final float TEXT_SIZE = 0.007f;
    private final ModelPart screen;
    private static final String SCREEN = "screen";

    public AssemblyControllerRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.ASSEMBLY_CONTROLLER);
        this.screen = root.getChild(SCREEN);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(SCREEN, CubeListBuilder.create().texOffs(0, 0).addBox("screen_0", -1.0f, 0.0f, -1.0f, 12, 6, 2, 16, 0).mirror(), PartPose.offsetAndRotation((float)-5.0f, (float)8.0f, (float)1.0f, (float)-0.5934119f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(AssemblyControllerBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_ASSEMBLY_CONTROLLER));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f + Minecraft.getInstance().gameRenderer.getMainCamera().getYRot()));
        this.screen.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(-0.23, 0.5, -0.04);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-34.0f));
        matrixStackIn.scale(0.007f, 0.007f, 0.007f);
        Minecraft.getInstance().font.drawInBatch("> " + te.displayedText, 1.0f, 4.0f, -11737752, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        if (te.hasProblem) {
            RenderUtils.drawTexture(matrixStackIn, bufferIn.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.GUI_GREEN_PROBLEMS_TEXTURE)), 0, 18, combinedLightIn);
        }
    }
}

