/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.AirCannonBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class AirCannonRenderer
extends AbstractBlockEntityModelRenderer<AirCannonBlockEntity> {
    private final ModelPart baseTurn;
    private final ModelPart baseFrame1;
    private final ModelPart baseFrame2;
    private final ModelPart axis;
    private final ModelPart cannon;
    private static final String BASETURN = "baseTurn";
    private static final String BASEFRAME1 = "baseFrame1";
    private static final String BASEFRAME2 = "baseFrame2";
    private static final String AXIS = "axis";
    private static final String CANNON = "cannon";

    public AirCannonRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.AIR_CANNON);
        this.baseTurn = root.getChild(BASETURN);
        this.baseFrame1 = root.getChild(BASEFRAME1);
        this.baseFrame2 = root.getChild(BASEFRAME2);
        this.axis = root.getChild(AXIS);
        this.cannon = root.getChild(CANNON);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BASETURN, CubeListBuilder.create().texOffs(0, 0).addBox("baseTurn_0", 0.0f, 0.0f, 0.0f, 7, 1, 7, 0, 0), PartPose.offset((float)-3.5f, (float)20.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild(BASEFRAME1, CubeListBuilder.create().texOffs(0, 0).addBox("baseFrame1_0", 0.0f, 0.0f, 0.0f, 1, 5, 3, 28, 0).mirror(), PartPose.offset((float)-3.5f, (float)15.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild(BASEFRAME2, CubeListBuilder.create().texOffs(0, 0).addBox("baseFrame2_0", 0.0f, 0.0f, 0.0f, 1, 5, 3, 36, 0).mirror(), PartPose.offset((float)2.5f, (float)15.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild(AXIS, CubeListBuilder.create().texOffs(0, 0).addBox("axis_0", -1.0f, 0.0f, -0.5f, 8, 2, 2, new CubeDeformation(-0.2f), 44, 4).mirror(), PartPose.offset((float)-3.0f, (float)15.5f, (float)-2.0f));
        partdefinition.addOrReplaceChild(CANNON, CubeListBuilder.create().texOffs(0, 0).addBox("cannon_0", -1.0f, 0.0f, -1.0f, 4, 4, 4, 0, 8).addBox("cannon_1", -0.5f, -2.0f, -0.5f, 3, 2, 3, 24, 8).addBox("cannon_2", -1.0f, -3.75f, -0.5f, 1, 2, 3, new CubeDeformation(-0.2f), 36, 8).addBox("cannon_3", 2.0f, -3.75f, -0.5f, 1, 2, 3, new CubeDeformation(-0.2f), 44, 8).addBox("cannon_4", -1.0f, -3.75f, -1.0f, 4, 2, 1, new CubeDeformation(-0.2f), 44, 13).addBox("cannon_5", -1.0f, -3.75f, 2.0f, 4, 2, 1, new CubeDeformation(-0.2f), 34, 13).mirror(), PartPose.offset((float)-1.0f, (float)15.0f, (float)-2.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    void renderModel(AirCannonBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_AIR_CANNON));
        float angle = RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        float rotationAngle = te.rotationAngle - angle + 180.0f;
        matrixStackIn.translate(0.0, 0.0, -0.09375);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotationAngle));
        matrixStackIn.translate(0.0, 0.0, 0.09375);
        this.baseTurn.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseFrame1.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseFrame2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.axis.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0, 1.0, -0.09375);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(te.heightAngle));
        matrixStackIn.translate(0.0, -1.0, 0.09375);
        this.cannon.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }
}

