/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class TrackerBlacklistManager {
    private static final Set<BlockEntityType<?>> ENERGY_BLACKLIST = Sets.newHashSet();
    private static final Set<BlockEntityType<?>> INVENTORY_BLACKLIST = Sets.newHashSet();
    private static final Set<BlockEntityType<?>> FLUID_BLACKLIST = Sets.newHashSet();

    public static void addEnergyTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(ENERGY_BLACKLIST, te, e);
    }

    public static void addInventoryTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(INVENTORY_BLACKLIST, te, e);
    }

    public static void addFluidTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(FLUID_BLACKLIST, te, e);
    }

    private static void addEntry(Set<BlockEntityType<?>> blacklist, BlockEntity te, Throwable e) {
        if (!blacklist.contains(te.getType())) {
            e.printStackTrace();
            String title = PneumaticCraftUtils.getRegistryName(te.getBlockState().getBlock()).orElseThrow().toString();
            HUDHandler.getInstance().addMessage((Component)Component.literal((String)("Block tracking failed for " + title + "!")), (List<Component>)ImmutableList.of((Object)Component.literal((String)"A stacktrace can be found in the log.")), 80, -65536);
            blacklist.add(te.getType());
        }
    }

    static boolean isEnergyBlacklisted(BlockEntity te) {
        return ENERGY_BLACKLIST.contains(te.getType());
    }

    static boolean isInventoryBlacklisted(BlockEntity te) {
        return INVENTORY_BLACKLIST.contains(te.getType());
    }

    static boolean isFluidBlacklisted(BlockEntity te) {
        return FLUID_BLACKLIST.contains(te.getType());
    }
}

