/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class WidgetEnergy
extends AbstractWidget {
    private static final int DEFAULT_SCALE = 42;
    private final IEnergyStorage storage;

    public WidgetEnergy(int x, int y, IEnergyStorage storage) {
        super(x, y, 16, 42, (Component)Component.empty());
        this.storage = storage;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int amount = this.getScaled();
        int x = this.getX();
        int y = this.getY();
        graphics.blit(Textures.WIDGET_ENERGY, x + 1, y, 1.0f, 0.0f, this.width - 2, this.height, 32, 64);
        graphics.blit(Textures.WIDGET_ENERGY, x + 1, y + 42 - amount, 17.0f, (float)(42 - amount), this.width - 2, amount, 32, 64);
        if (this.isHovered) {
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(this.storage.getEnergyStored() + " / " + this.storage.getMaxEnergyStored() + " FE")), mouseX, mouseY);
        }
    }

    private int getScaled() {
        if (this.storage.getMaxEnergyStored() <= 0) {
            return this.height;
        }
        return this.storage.getEnergyStored() * this.height / this.storage.getMaxEnergyStored();
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

