/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.client.pneumatic_helmet;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

public interface IArmorUpgradeClientHandler<T extends IArmorUpgradeHandler<?>> {
    public T getCommonHandler();

    default public ResourceLocation getID() {
        return this.getCommonHandler().getID();
    }

    default public void initConfig() {
    }

    default public void saveToConfig() {
    }

    public void tickClient(ICommonArmorHandler var1, boolean var2);

    public void render3D(PoseStack var1, MultiBufferSource var2, float var3);

    public void render2D(GuiGraphics var1, float var2, boolean var3);

    default public IGuiAnimatedStat getAnimatedStat() {
        return null;
    }

    default public StatPanelLayout getDefaultStatLayout() {
        return StatPanelLayout.DEFAULT;
    }

    public void reset();

    public IOptionPage getGuiOptionsPage(IGuiScreen var1);

    default public void onResolutionChanged() {
    }

    default public boolean isToggleable() {
        return true;
    }

    default public Optional<KeyMapping> getInitialKeyBinding() {
        return this.isToggleable() ? Optional.of(new KeyMapping(IArmorUpgradeHandler.getStringKey(this.getID()), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, -1, this.getKeybindCategory())) : Optional.empty();
    }

    default public Collection<ResourceLocation> getSubKeybinds() {
        return Collections.emptyList();
    }

    default public Optional<KeyMapping> getTriggerKeyBinding() {
        return Optional.empty();
    }

    default public void onTriggered(ICommonArmorHandler armorHandler) {
    }

    default public String getKeybindCategory() {
        return "key.pneumaticcraft.category.upgrade_toggles";
    }

    default public String getSubKeybindCategory() {
        return "key.pneumaticcraft.category.upgrade_toggles";
    }

    default public void setOverlayColor(int color) {
        IGuiAnimatedStat stat = this.getAnimatedStat();
        if (stat != null) {
            stat.setBackgroundColor(color);
        }
    }

    default public boolean isEnabledByDefault() {
        return false;
    }

    default public boolean isEnabledByDefault(String subModuleName) {
        return false;
    }

    public static abstract class SimpleToggleableHandler<T extends IArmorUpgradeHandler<?>>
    extends AbstractHandler<T> {
        public SimpleToggleableHandler(T commonHandler) {
            super(commonHandler);
        }

        @Override
        public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        }

        @Override
        public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        }

        @Override
        public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
        }

        @Override
        public void reset() {
        }

        @Override
        public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
            return new IOptionPage.SimpleOptionPage<SimpleToggleableHandler>(screen, this);
        }
    }

    public static abstract class AbstractHandler<T extends IArmorUpgradeHandler<?>>
    implements IArmorUpgradeClientHandler<T> {
        private final T commonHandler;

        public AbstractHandler(T commonHandler) {
            this.commonHandler = commonHandler;
        }

        @Override
        public T getCommonHandler() {
            return this.commonHandler;
        }
    }
}

