/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.polylib.DataEntity;
import vswe.stevescarts.polylib.EntityData;

public class PacketEntityData
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketEntityData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"entity_data"));
    private final int entityId;
    private final int index;
    private final AbstractDataStore<?> data;
    private RegistryFriendlyByteBuf buffer = null;

    public PacketEntityData(int entityId, int index, AbstractDataStore<?> data) {
        this.entityId = entityId;
        this.index = index;
        this.data = data;
    }

    public PacketEntityData(int entityId, int index, RegistryFriendlyByteBuf buffer) {
        this.entityId = entityId;
        this.index = index;
        this.buffer = buffer;
        this.data = null;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.entityId);
        buf.writeVarInt(this.index);
        this.data.toBytes(buf);
    }

    public static PacketEntityData read(RegistryFriendlyByteBuf buffer) {
        int entityId = buffer.readVarInt();
        int index = buffer.readVarInt();
        ByteBuf copy = buffer.copy();
        while (buffer.readableBytes() > 0) {
            buffer.readByte();
        }
        return new PacketEntityData(entityId, index, new RegistryFriendlyByteBuf(copy, buffer.registryAccess()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(PacketEntityData msg, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(msg.entityId);
        if (!(entity instanceof DataEntity)) {
            return;
        }
        DataEntity dataEntity = (DataEntity)entity;
        List<EntityData<?>> list = dataEntity.getEntityDataList();
        if (msg.index < 0 || msg.index >= list.size()) {
            return;
        }
        EntityData<?> data = list.get(msg.index);
        if (msg.buffer != null) {
            data.fromBytes(msg.buffer);
        } else {
            data.set(PacketEntityData.cast(msg.data.get()));
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    public static class Handler
    implements IPayloadHandler<PacketEntityData> {
        public void handle(PacketEntityData msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.CLIENTBOUND) {
                return;
            }
            ctx.enqueueWork(() -> PacketEntityData.handleClientSide(msg, ctx));
        }
    }
}

