/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;

public class PacketDistributorTile
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketDistributorTile> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"distributor"));
    private final BlockPos blockPos;
    private final int id;
    private final byte[] array;

    public PacketDistributorTile(BlockPos blockPos, int id, byte[] array) {
        this.blockPos = blockPos;
        this.id = id;
        this.array = array;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.array);
    }

    public static PacketDistributorTile read(FriendlyByteBuf buffer) {
        return new PacketDistributorTile(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static class Handler
    implements IPayloadHandler<PacketDistributorTile> {
        public void handle(PacketDistributorTile msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.SERVERBOUND) {
                return;
            }
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (msg.blockPos != null && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    BlockEntity patt1$temp;
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    BlockPos blockPos = msg.blockPos;
                    if (player.level().getBlockEntity(blockPos) != null && (patt1$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityDistributor) {
                        TileEntityDistributor tileEntityDistributor = (TileEntityDistributor)patt1$temp;
                        tileEntityDistributor.receivePacket(msg.id, msg.array, player);
                    }
                }
            });
        }
    }
}

