/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.List;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleExperience
extends ModuleBase {
    private static final int MAX_EXPERIENCE_AMOUNT = 1500;
    private final EntityData<Integer> experience = new EntityData(this.getCart(), new IntData(0));

    public ModuleExperience(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        List list = this.getCart().level().getEntities((Entity)this.getCart(), this.getCart().getBoundingBox().inflate(3.0, 1.0, 3.0));
        for (Entity entity : list) {
            if (!(entity instanceof ExperienceOrb)) continue;
            this.addExperience(((ExperienceOrb)entity).getValue());
            if (this.getExperienceAmount() > 1500) {
                this.setExperienceAmount(1500);
                continue;
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void addExperience(int amount) {
        int val = this.getExperienceAmount();
        this.setExperienceAmount(val += amount);
    }

    public int getExperienceAmount() {
        int val = this.experience.get();
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    private void setExperienceAmount(int val) {
        if (!this.isPlaceholder()) {
            this.experience.set(val);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE_LEVEL.translate(String.valueOf(this.getExperienceAmount()), String.valueOf(1500)) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_EXTRACT.translate(new String[0]) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_EXTRACT_ALL.translate(new String[0]) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_PLAYER_LEVEL.translate(String.valueOf(this.getClientPlayer().experienceLevel)), x, y, this.getContainerRect());
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE.translate(new String[0]), 8, 6, 0x404040);
    }

    private int[] getContainerRect() {
        return new int[]{10, 15, 26, 65};
    }

    private int[] getContentRect(float part) {
        int[] cont = this.getContainerRect();
        int normalHeight = cont[3] - 4;
        int currentHeight = (int)((float)normalHeight * part);
        return new int[]{cont[0] + 2, cont[1] + 2 + normalHeight - currentHeight, cont[2] - 4, currentHeight, normalHeight};
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawContent(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y, int id) {
        int lowerLevel = id * 1500 / 3;
        int currentLevel = this.getExperienceAmount() - lowerLevel;
        float part = 3.0f * (float)currentLevel / 1500.0f;
        if (part > 1.0f) {
            part = 1.0f;
        }
        int[] content = this.getContentRect(part);
        this.drawImage(guiGraphics, gui, content, 4 + content[2] * (id + 1), content[4] - content[3]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/experience.png");
        for (int i = 0; i < 3; ++i) {
            this.drawContent(guiGraphics, gui, x, y, i);
        }
        this.drawImage(guiGraphics, gui, this.getContainerRect(), 0, this.inRect(x, y, this.getContainerRect()) ? 65 : 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.getContainerRect())) {
            this.sendPacket(0, (byte)(Screen.hasShiftDown() ? 1 : 0));
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 70;
    }

    @Override
    public int guiHeight() {
        return 84;
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        int give = data[0] == 1 ? this.getExperienceAmount() : Math.min(this.getExperienceAmount(), 50);
        player.giveExperiencePoints(give);
        this.setExperienceAmount(this.getExperienceAmount() - give);
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        this.setExperienceAmount(tagCompound.getShort(this.generateNBTName("Experience", id)));
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putShort(this.generateNBTName("Experience", id), (short)this.getExperienceAmount());
    }
}

