/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.HeightControlOre;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleHeightControl
extends ModuleAddon {
    private int levelNumberBoxX = 8;
    private int levelNumberBoxY = 18;
    private int[] arrowUp;
    private int[] arrowMiddle;
    private int[] arrowDown;
    private int oreMapX = 40;
    private int oreMapY = 18;
    private final EntityData<Integer> yTarget = new EntityData(this.getCart(), new IntData(this.getCart().y()));

    public ModuleHeightControl(EntityMinecartModular cart) {
        super(cart);
        this.arrowUp = new int[]{9, 36, 17, 9};
        this.arrowMiddle = new int[]{9, 46, 17, 6};
        this.arrowDown = new int[]{9, 53, 17, 9};
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return Math.max(100, this.oreMapX + 5 + HeightControlOre.ores.size() * 4);
    }

    @Override
    public int guiHeight() {
        return 65;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
        String s = String.valueOf(this.getYTarget());
        int x = this.levelNumberBoxX + 6;
        int color = 0xFFFFFF;
        if (this.getYTarget() >= 100) {
            x -= 4;
        } else if (this.getYTarget() < 0) {
            x -= 4;
        } else if (this.getYTarget() < 10) {
            x += 3;
        }
        this.drawString(guiGraphics, gui, s, x, this.levelNumberBoxY + 5, color);
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        int pos;
        ResourceHelper.bindResource("/gui/heightcontrol.png");
        this.drawImage(guiGraphics, gui, this.levelNumberBoxX, this.levelNumberBoxY, 4, 36, 21, 15);
        this.drawImage(guiGraphics, gui, this.arrowUp, 4, 12);
        this.drawImage(guiGraphics, gui, this.arrowMiddle, 4, 21);
        this.drawImage(guiGraphics, gui, this.arrowDown, 4, 27);
        for (int i = 0; i < HeightControlOre.ores.size(); ++i) {
            HeightControlOre ore = HeightControlOre.ores.get(i);
            for (int j = 0; j < 11; ++j) {
                int srcX;
                int srcY;
                boolean high;
                int altitude = this.getYTarget() - j + 5;
                boolean empty = ore.spanLowest > altitude || altitude > ore.spanHighest;
                boolean bl = high = ore.bestLowest <= altitude && altitude <= ore.bestHighest;
                if (empty) {
                    srcY = 0;
                    srcX = 0;
                } else {
                    srcX = ore.srcX;
                    srcY = ore.srcY;
                    if (high) {
                        srcY += 4;
                    }
                }
                this.drawImage(guiGraphics, gui, this.oreMapX + i * 4, this.oreMapY + j * 4, srcX, srcY, 4, 4);
            }
        }
        if (this.getYTarget() != this.getCart().y()) {
            this.drawMarker(guiGraphics, gui, 5, false);
        }
        if ((pos = this.getYTarget() + 5 - this.getCart().y()) >= 0 && pos < 11) {
            this.drawMarker(guiGraphics, gui, pos, true);
        }
    }

    private void drawMarker(GuiGraphics guiGraphics, GuiMinecart gui, int pos, boolean isTargetLevel) {
        int srcX = 4;
        int srcY = isTargetLevel ? 6 : 0;
        this.drawImage(guiGraphics, gui, this.oreMapX - 1, this.oreMapY + pos * 4 - 1, srcX, srcY, 1, 6);
        for (int i = 0; i < HeightControlOre.ores.size(); ++i) {
            this.drawImage(guiGraphics, gui, this.oreMapX + i * 4, this.oreMapY + pos * 4 - 1, srcX + 1, srcY, 4, 6);
        }
        this.drawImage(guiGraphics, gui, this.oreMapX + HeightControlOre.ores.size() * 4, this.oreMapY + pos * 4 - 1, srcX + 5, srcY, 1, 6);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            byte packetData = 0;
            if (this.inRect(x, y, this.arrowMiddle)) {
                packetData = (byte)(packetData | 1);
            } else {
                if (!this.inRect(x, y, this.arrowUp)) {
                    if (!this.inRect(x, y, this.arrowDown)) {
                        return;
                    }
                    packetData = (byte)(packetData | 2);
                }
                if (Screen.hasShiftDown()) {
                    packetData = (byte)(packetData | 4);
                }
            }
            this.sendPacket(0, packetData);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte info = data[0];
            if ((info & 1) != 0) {
                this.setYTarget(this.getCart().y());
            } else {
                int mult = (info & 2) == 0 ? 1 : -1;
                int dif = (info & 4) == 0 ? 1 : 10;
                int targetY = this.getYTarget();
                int min = this.getCart().level().getMinBuildHeight();
                int max = this.getCart().level().getMaxBuildHeight();
                if ((targetY += mult * dif) < min) {
                    targetY = min;
                } else if (targetY > max) {
                    targetY = max;
                }
                this.setYTarget(targetY);
            }
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    public void setYTarget(int val) {
        this.yTarget.set(val);
    }

    @Override
    public int getYTarget() {
        if (this.isPlaceholder()) {
            return 64;
        }
        int data = this.yTarget.get();
        return data;
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putShort(this.generateNBTName("Height", id), (short)this.getYTarget());
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        this.setYTarget(tagCompound.getShort(this.generateNBTName("Height", id)));
    }
}

