/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.IntArrayData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleColorRandomizer
extends ModuleAddon {
    private int[] button;
    private int cooldown;
    private boolean hover;
    private Random random;
    private final EntityData<int[]> colors = new EntityData<int[]>(this.getCart(), new IntArrayData(new int[]{255, 255, 255}));

    public ModuleColorRandomizer(EntityMinecartModular cart) {
        super(cart);
        this.button = new int[]{10, 26, 16, 16};
        this.random = new Random();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 50;
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/color_randomizer.png");
        this.drawImage(guiGraphics, gui, 50, 20, 0, 16, 28, 28);
        if (this.inRect(x, y, this.button)) {
            this.drawImage(guiGraphics, gui, 10, 26, 32, 0, 16, 16);
        } else {
            this.drawImage(guiGraphics, gui, 10, 26, 16, 0, 16, 16);
        }
        this.drawImage(guiGraphics, gui, 10, 26, 0, 0, 16, 16);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        if (this.inRect(x, y, this.button)) {
            String randomizeString = Localization.MODULES.ADDONS.BUTTON_RANDOMIZE.translate(new String[0]);
            this.drawStringOnMouseOver(guiGraphics, gui, randomizeString, x, y, this.button);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.button)) {
            this.sendPacket(0);
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.cooldown == 0) {
            this.randomizeColor();
            this.cooldown = 5;
        }
    }

    @Override
    public void update() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    private void randomizeColor() {
        int red = this.random.nextInt(256);
        int green = this.random.nextInt(256);
        int blue = this.random.nextInt(256);
        this.setColorVal(0, (byte)red);
        this.setColorVal(1, (byte)green);
        this.setColorVal(2, (byte)blue);
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.randomizeColor();
        }
    }

    public int getColorVal(int i) {
        if (this.isPlaceholder()) {
            return 255;
        }
        int tempVal = this.colors.get()[i];
        if (tempVal < 0) {
            tempVal += 256;
        }
        return tempVal;
    }

    public void setColorVal(int id, int val) {
        int[] colors = this.colors.get();
        colors[id] = val;
        this.colors.set(colors);
    }

    private float getColorComponent(int i) {
        return (float)this.getColorVal(i) / 255.0f;
    }

    @Override
    public float[] getColor() {
        return new float[]{this.getColorComponent(0), this.getColorComponent(1), this.getColorComponent(2)};
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putByte(this.generateNBTName("Red", id), (byte)this.getColorVal(0));
        tagCompound.putByte(this.generateNBTName("Green", id), (byte)this.getColorVal(1));
        tagCompound.putByte(this.generateNBTName("Blue", id), (byte)this.getColorVal(2));
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        this.setColorVal(0, tagCompound.getByte(this.generateNBTName("Red", id)));
        this.setColorVal(1, tagCompound.getByte(this.generateNBTName("Green", id)));
        this.setColorVal(2, tagCompound.getByte(this.generateNBTName("Blue", id)));
    }
}

