/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.slots.SlotAssembler;
import vswe.stevescarts.init.ModContainers;

public class ContainerCartAssembler
extends ContainerBase {
    private TileEntityCartAssembler assembler;
    private SimpleContainerData data;

    public ContainerCartAssembler(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityCartAssembler)Objects.requireNonNull(Minecraft.getInstance().level.getBlockEntity(packetBuffer.readBlockPos())), new SimpleContainerData(7));
    }

    public ContainerCartAssembler(int id, Inventory invPlayer, TileEntityCartAssembler assembler, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_CART_ASSEMBLER.get(), id);
        this.data = data;
        this.assembler = assembler;
        ArrayList<SlotAssembler> slots = assembler.getSlots();
        for (SlotAssembler slot : slots) {
            this.addSlot(slot);
        }
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)invPlayer, k + i * 9 + 9, this.offsetX() + k * 18, i * 18 + this.offsetY()));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)invPlayer, j, this.offsetX() + j * 18, 58 + this.offsetY()));
        }
        this.addDataSlots((ContainerData)data);
    }

    public TileEntityCartAssembler getAssembler() {
        return this.assembler;
    }

    protected int offsetX() {
        return 176;
    }

    protected int offsetY() {
        return 174;
    }

    public int getFuel() {
        return this.assembler.getIntFromShorts((short)this.data.get(5), (short)this.data.get(6));
    }

    public int getAssemblingTime() {
        return this.assembler.getIntFromShorts((short)this.data.get(2), (short)this.data.get(3));
    }

    public int getMaxAssemblingTime() {
        return this.assembler.getIntFromShorts((short)this.data.get(0), (short)this.data.get(1));
    }

    public boolean getIsAssembling() {
        return this.data.get(4) == 1;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.assembler.isUsableByPlayer(player);
    }
}

