/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.init.ModItemData;
import vswe.stevescarts.init.ModItems;

public class ItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    public static ItemStackRenderer instance;

    public ItemStackRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int p_239207_5_, int p_239207_6_) {
        if (itemStack.getItem() != ModItems.CARTS.get()) {
            super.renderByItem(itemStack, transformType, matrixStack, iRenderTypeBuffer, p_239207_5_, p_239207_6_);
            return;
        }
        matrixStack.pushPose();
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        CompoundTag info = ModItemData.getTagCopy(itemStack);
        if (info.contains("modules")) {
            float lowestMult = 1.0f;
            EntityMinecartModular cart = new EntityMinecartModular((Level)Minecraft.getInstance().level, 0.0, 0.0, 0.0, info, (Component)Component.literal((String)""));
            if (transformType == ItemDisplayContext.GUI) {
                matrixStack.translate(-1.0f, 0.0f, 0.0f);
                matrixStack.scale(lowestMult, lowestMult, lowestMult);
            } else {
                matrixStack.translate(-0.5, -0.5, 0.5);
            }
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            if (cart.getModules() != null) {
                for (ModuleBase module : cart.getModules()) {
                    if (module.getModels() == null) continue;
                    for (ModelCartbase model : module.getModels()) {
                        VertexConsumer buffer = iRenderTypeBuffer.getBuffer(model.getRenderType(module));
                        model.applyEffects(module, matrixStack, iRenderTypeBuffer, 0.0f, 0.0f, 0.0f);
                        model.renderToBuffer(matrixStack, buffer, p_239207_5_, p_239207_6_, -1);
                    }
                }
            }
        }
        matrixStack.popPose();
    }

    public static ItemStackRenderer getInstance() {
        if (instance == null) {
            instance = new ItemStackRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
        return instance;
    }
}

