/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward;

import com.google.gson.JsonParser;
import com.hrznstudio.titanium.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;

public class Reward {
    public static Calendar BUUZ_BIRTH_DATE = Calendar.getInstance();
    private final ResourceLocation resourceLocation;
    private final URL contributorsURL;
    private String unlocalizedName;
    private List<UUID> players;
    private Supplier<Consumer<Dist>> register;
    private String[] options;

    public Reward(ResourceLocation resourceLocation, URL contributorsURL, Supplier<Consumer<Dist>> register, String[] options) {
        this.resourceLocation = resourceLocation;
        this.contributorsURL = contributorsURL;
        this.players = new ArrayList<UUID>();
        this.register = register;
        this.options = options;
        new Thread(() -> {
            this.players = Reward.getPlayers(contributorsURL);
        }).start();
    }

    private static List<UUID> getPlayers(URL url) {
        try {
            ArrayList<UUID> players = new ArrayList<UUID>();
            new JsonParser().parse(URLUtil.readUrl(url)).getAsJsonObject().get("uuid").getAsJsonArray().forEach(jsonElement -> players.add(UUID.fromString(jsonElement.getAsString())));
            return players;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<UUID>();
        }
    }

    public Reward setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public void register(Dist dist) {
        this.register.get().accept(dist);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public String[] getOptions() {
        return this.options;
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    public boolean isPlayerValid(UUID uuid) {
        if (Calendar.getInstance().get(3) == BUUZ_BIRTH_DATE.get(3)) {
            return true;
        }
        return this.players.contains(uuid);
    }

    static {
        BUUZ_BIRTH_DATE.set(BUUZ_BIRTH_DATE.get(1), 1, 12);
    }
}

