/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.extensions.IFriendlyByteBufExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CompoundSerializableDataHandler {
    private static final HashMap<Class, Pair<Reader, Writer>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, StreamCodec<? extends ByteBuf, T> codec) {
        StreamCodec raw = codec;
        FIELD_SERIALIZER.put(type, (Pair<Reader, Writer>)Pair.of(buf -> raw.decode((Object)buf), (buf, object) -> raw.encode((Object)buf, object)));
    }

    public static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        FIELD_SERIALIZER.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static long[] readLongArray(FriendlyByteBuf buf) {
        return buf.readLongArray(new long[0]);
    }

    private static String readString(FriendlyByteBuf buf) {
        return buf.readUtf(Short.MAX_VALUE);
    }

    private static FluidStack readFluidStack(RegistryFriendlyByteBuf buf) throws IOException {
        return (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf);
    }

    private static void writeFluidStack(RegistryFriendlyByteBuf buf, FluidStack stack) {
        FluidStack.STREAM_CODEC.encode((Object)buf, (Object)stack);
    }

    public static ResourceKey<?> readRegistryKey(FriendlyByteBuf buffer) {
        return ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)buffer.readResourceLocation()), (ResourceLocation)buffer.readResourceLocation());
    }

    public static void writeRegistryKey(FriendlyByteBuf buffer, ResourceKey<?> biome) {
        buffer.writeResourceLocation(biome.registry());
        buffer.writeResourceLocation(biome.location());
    }

    private static void writeUpdatePacket(RegistryFriendlyByteBuf buf, ClientboundBlockEntityDataPacket packet) {
        ClientboundBlockEntityDataPacket.STREAM_CODEC.encode((Object)buf, (Object)packet);
    }

    private static Ingredient.Value[] readIItemListArray(RegistryFriendlyByteBuf buf) {
        Ingredient.Value[] list = new Ingredient.Value[buf.readInt()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new CollectionItemList(buf);
        }
        return list;
    }

    private static void writeIItemListArray(RegistryFriendlyByteBuf buf, Ingredient.Value[] list) {
        buf.writeInt(list.length);
        for (Ingredient.Value iItemList : list) {
            CollectionItemList.serializeBuffer(buf, iItemList);
        }
    }

    public static ResourceKey<?>[] readRegistryArray(FriendlyByteBuf buffer) {
        ResourceKey[] registryKeys = new ResourceKey[buffer.readInt()];
        for (int i = 0; i < registryKeys.length; ++i) {
            registryKeys[i] = CompoundSerializableDataHandler.readRegistryKey(buffer);
        }
        return registryKeys;
    }

    public static void writeRegistryArray(FriendlyByteBuf buffer, ResourceKey<?>[] registryKeys) {
        buffer.writeInt(registryKeys.length);
        for (ResourceKey<?> registryKey : registryKeys) {
            CompoundSerializableDataHandler.writeRegistryKey(buffer, registryKey);
        }
    }

    public static Ingredient[] readIngredientArray(RegistryFriendlyByteBuf buffer) {
        Ingredient[] ingredients = new Ingredient[buffer.readInt()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        }
        return ingredients;
    }

    public static void writeIngredientArray(RegistryFriendlyByteBuf buffer, Ingredient[] ingredients) {
        buffer.writeInt(ingredients.length);
        for (Ingredient ingredient : ingredients) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
    }

    private static ClientboundBlockEntityDataPacket readUpdatePacket(RegistryFriendlyByteBuf buf) {
        return (ClientboundBlockEntityDataPacket)ClientboundBlockEntityDataPacket.STREAM_CODEC.decode((Object)buf);
    }

    public static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = FIELD_SERIALIZER.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + String.valueOf(clazz));
        }
        return pair;
    }

    public static void writeField(Field f, Class clazz, RegistryFriendlyByteBuf buf, Object instance) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f.get(instance));
    }

    public static void readField(Field f, Class clazz, RegistryFriendlyByteBuf buf, Object instance) throws IllegalArgumentException, IllegalAccessException, IOException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        f.set(instance, ((Reader)handler.getLeft()).read(buf));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && CompoundSerializableDataHandler.getHandler(type) != null;
    }

    static {
        CompoundSerializableDataHandler.map(Byte.TYPE, FriendlyByteBuf::readByte, IFriendlyByteBufExtension::writeByte);
        CompoundSerializableDataHandler.map(Short.TYPE, FriendlyByteBuf::readShort, FriendlyByteBuf::writeShort);
        CompoundSerializableDataHandler.map(Integer.TYPE, FriendlyByteBuf::readVarInt, FriendlyByteBuf::writeVarInt);
        CompoundSerializableDataHandler.map(Long.TYPE, FriendlyByteBuf::readVarLong, FriendlyByteBuf::writeVarLong);
        CompoundSerializableDataHandler.map(Float.TYPE, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
        CompoundSerializableDataHandler.map(Double.TYPE, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.TYPE, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
        CompoundSerializableDataHandler.map(Character.TYPE, FriendlyByteBuf::readChar, FriendlyByteBuf::writeChar);
        CompoundSerializableDataHandler.map(Byte.class, FriendlyByteBuf::readByte, IFriendlyByteBufExtension::writeByte);
        CompoundSerializableDataHandler.map(Short.class, FriendlyByteBuf::readShort, FriendlyByteBuf::writeShort);
        CompoundSerializableDataHandler.map(Integer.class, FriendlyByteBuf::readVarInt, FriendlyByteBuf::writeVarInt);
        CompoundSerializableDataHandler.map(Long.class, FriendlyByteBuf::readVarLong, FriendlyByteBuf::writeVarLong);
        CompoundSerializableDataHandler.map(Float.class, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
        CompoundSerializableDataHandler.map(Double.class, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.class, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
        CompoundSerializableDataHandler.map(Character.class, FriendlyByteBuf::readChar, FriendlyByteBuf::writeChar);
        CompoundSerializableDataHandler.map(byte[].class, buf -> buf.readByteArray(), FriendlyByteBuf::writeBytes);
        CompoundSerializableDataHandler.map(int[].class, FriendlyByteBuf::readVarIntArray, FriendlyByteBuf::writeVarIntArray);
        CompoundSerializableDataHandler.map(long[].class, CompoundSerializableDataHandler::readLongArray, FriendlyByteBuf::writeLongArray);
        CompoundSerializableDataHandler.map(String.class, CompoundSerializableDataHandler::readString, FriendlyByteBuf::writeUtf);
        CompoundSerializableDataHandler.map(CompoundTag.class, ByteBufCodecs.TRUSTED_COMPOUND_TAG);
        CompoundSerializableDataHandler.map(ItemStack.class, ItemStack.STREAM_CODEC);
        CompoundSerializableDataHandler.map(FluidStack.class, CompoundSerializableDataHandler::readFluidStack, CompoundSerializableDataHandler::writeFluidStack);
        CompoundSerializableDataHandler.map(BlockPos.class, BlockPos.STREAM_CODEC);
        CompoundSerializableDataHandler.map(Component.class, ComponentSerialization.STREAM_CODEC);
        CompoundSerializableDataHandler.map(Date.class, FriendlyByteBuf::readDate, FriendlyByteBuf::writeDate);
        CompoundSerializableDataHandler.map(UUID.class, UUIDUtil.STREAM_CODEC);
        CompoundSerializableDataHandler.map(ClientboundBlockEntityDataPacket.class, CompoundSerializableDataHandler::readUpdatePacket, CompoundSerializableDataHandler::writeUpdatePacket);
        CompoundSerializableDataHandler.map(LocatorInstance.class, LocatorFactory::readPacketBuffer, LocatorFactory::writePacketBuffer);
        CompoundSerializableDataHandler.map(Ingredient.Value.class, CollectionItemList::new, CollectionItemList::serializeBuffer);
        CompoundSerializableDataHandler.map(Ingredient.class, Ingredient.CONTENTS_STREAM_CODEC);
        CompoundSerializableDataHandler.map(Block.class, buf -> (Block)BuiltInRegistries.BLOCK.get(buf.readResourceLocation()), (buf, block) -> buf.writeResourceLocation(BuiltInRegistries.BLOCK.getKey(block)));
        CompoundSerializableDataHandler.map(Ingredient.Value[].class, CompoundSerializableDataHandler::readIItemListArray, CompoundSerializableDataHandler::writeIItemListArray);
        CompoundSerializableDataHandler.map(Ingredient[].class, CompoundSerializableDataHandler::readIngredientArray, CompoundSerializableDataHandler::writeIngredientArray);
        CompoundSerializableDataHandler.map(ResourceKey.class, CompoundSerializableDataHandler::readRegistryKey, CompoundSerializableDataHandler::writeRegistryKey);
        CompoundSerializableDataHandler.map(ResourceKey[].class, CompoundSerializableDataHandler::readRegistryArray, CompoundSerializableDataHandler::writeRegistryArray);
        CompoundSerializableDataHandler.map(ResourceLocation.class, FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::writeResourceLocation);
    }

    public static interface Reader<T> {
        public T read(RegistryFriendlyByteBuf var1) throws IOException;
    }

    public static interface Writer<T> {
        public void write(RegistryFriendlyByteBuf var1, T var2);
    }

    public static class CollectionItemList
    implements Ingredient.Value {
        private List<ItemStack> stackList = new ArrayList<ItemStack>();

        public CollectionItemList(RegistryFriendlyByteBuf buffer) {
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                this.stackList.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
        }

        public static void serializeBuffer(RegistryFriendlyByteBuf buffer, Ingredient.Value list) {
            buffer.writeInt(list.getItems().size());
            list.getItems().forEach(stack -> ItemStack.STREAM_CODEC.encode((Object)buffer, stack));
        }

        public Collection<ItemStack> getItems() {
            return this.stackList;
        }
    }
}

