/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.datagenerator.loot.block.IBlockLootTableProvider;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BasicBlock
extends Block
implements IRecipeProvider,
IBlockLootTableProvider {
    private TitaniumTab itemGroup = null;

    public BasicBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    protected static DistanceRayTraceResult rayTraceBox(BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape) {
        BlockHitResult bbResult = shape.clip(start, end, pos);
        if (bbResult != null) {
            Vec3 hitVec = bbResult.getLocation();
            Direction sideHit = bbResult.getDirection();
            double dist = start.distanceTo(hitVec);
            return new DistanceRayTraceResult(hitVec, sideHit, pos, shape, dist);
        }
        return null;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        if (this.hasCustomBoxes(state, world, pos)) {
            VoxelShape shape = Shapes.empty();
            for (VoxelShape shape1 : this.getBoundingBoxes(state, world, pos)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)shape1, (BooleanOp)BooleanOp.OR);
            }
            return shape;
        }
        return super.getCollisionShape(state, world, pos, selectionContext);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return Collections.emptyList();
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return false;
    }

    @Nullable
    protected HitResult rayTraceBoxesClosest(Vec3 start, Vec3 end, BlockPos pos, List<VoxelShape> boxes) {
        ArrayList<DistanceRayTraceResult> results = new ArrayList<DistanceRayTraceResult>();
        for (VoxelShape box : boxes) {
            DistanceRayTraceResult hit = BasicBlock.rayTraceBox(pos, start, end, box);
            if (hit == null) continue;
            results.add(hit);
        }
        DistanceRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (DistanceRayTraceResult hit : results) {
            if (!(curClosest > hit.getDistance())) continue;
            closestHit = hit;
            curClosest = hit.getDistance();
        }
        return closestHit;
    }

    public TitaniumTab getItemGroup() {
        return this.itemGroup;
    }

    public void setItemGroup(TitaniumTab itemGroup) {
        this.itemGroup = itemGroup;
    }

    @Override
    public void registerRecipe(RecipeOutput output) {
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            Containers.dropContents((Level)worldIn, (BlockPos)pos, this.getDynamicDrops(state, worldIn, pos, newState, isMoving));
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList stacks = NonNullList.create();
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof ActiveTile && ((ActiveTile)tileentity).getMultiInventoryComponent() != null) {
            for (InventoryComponent inventoryHandler : ((ActiveTile)tileentity).getMultiInventoryComponent().getInventoryHandlers()) {
                for (int i = 0; i < inventoryHandler.getSlots(); ++i) {
                    stacks.add((Object)inventoryHandler.getStackInSlot(i));
                }
            }
        }
        return stacks;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return false;
    }

    @Override
    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingSelf((ItemLike)this);
    }
}

