/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.WidgetContainerScreen;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlockEntityRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorScreen;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ItemCollectorsClient {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(ItemCollectorsClient::onBlockHighlight);
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"itemcollectors");
        handler.registerContainerScreen(() -> ItemCollectors.filter_collector_container, container -> WidgetContainerScreen.of((Widget)new AdvancedCollectorScreen(container.level, container.getCollectorPosition()), (BaseContainer)container, (boolean)false));
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.basic_collector_tile, CollectorBlockEntityRenderer::new);
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.advanced_collector_tile, CollectorBlockEntityRenderer::new);
    }

    public static void openBasicCollectorScreen(Level level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new BasicCollectorScreen(level, pos)));
    }

    public static void onBlockHighlight(RenderHighlightEvent.Block e) {
        Level level = ClientUtils.getWorld();
        BlockEntity entity = level.getBlockEntity(e.getTarget().getBlockPos());
        if (entity instanceof CollectorBlockEntity) {
            e.getPoseStack().pushPose();
            Vec3 camera = RenderUtils.getCameraPosition();
            e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
            AABB area = ((CollectorBlockEntity)entity).getAffectedArea().inflate((double)0.05f);
            Random random = new Random(entity.getBlockPos().hashCode());
            float red = random.nextFloat();
            float green = random.nextFloat();
            float blue = random.nextFloat();
            float alpha = 0.3f;
            RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
            e.getPoseStack().popPose();
        }
    }
}

